/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen.generator;

import io.vertx.codegen.CodeGenProcessor;
import io.vertx.codegen.Compiler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.codegen.Utils;
import io.vertx.test.codegen.testapi.InvalidInterfaceDataObject;
import io.vertx.test.codegen.testapi.MethodWithValidVertxGenParams;
import io.vertx.test.codegen.testapi.VertxGenClass1;
import io.vertx.test.codegen.testapi.VertxGenClass2;
import io.vertx.test.codegen.testdataobject.CommentedDataObject;
import io.vertx.test.codegen.testdataobject.PropertyGettersSetters;
import io.vertx.test.codegen.testenum.ValidEnum;
import io.vertx.test.codegen.testmodule.modulescoped.ModuleScopedApi;
import io.vertx.test.codegen.testmodule.modulescoped.sub.ModuleScopedSubApi;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.time.Instant;
import java.util.HashSet;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.processing.Processor;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class CodeGeneratorTest {
    @Rule
    public final TestName name = new TestName();
    private static File testDir;

    @Before
    public void before() throws Exception {
        String suffix;
        int count = 0;
        do {
            suffix = "testgen_" + this.name.getMethodName();
            if (count > 0) {
                suffix = suffix + "-" + count;
            }
            ++count;
        } while ((testDir = new File(new File("target").getAbsoluteFile(), suffix)).exists());
        Assert.assertTrue((boolean)testDir.mkdir());
    }

    private Properties assertCompile(String gen, Class ... classes) throws Exception {
        Compiler compiler = new Compiler((Processor)new CodeGenProcessor());
        compiler.addOption("-Acodegen.generators=" + gen);
        compiler.addOption("-Acodegen.output=" + testDir.getAbsolutePath());
        Assert.assertTrue((boolean)compiler.compile(classes));
        File f = new File(testDir, classes[0].getName().replace('.', '_') + ".properties");
        Properties props = new Properties();
        props.load(new FileInputStream(f));
        return props;
    }

    @Test
    public void testClassGen() throws Exception {
        Properties props = this.assertCompile("testgen1", MethodWithValidVertxGenParams.class, VertxGenClass1.class, VertxGenClass2.class);
        Assert.assertEquals((Object)("[" + VertxGenClass1.class.getName() + ", " + VertxGenClass2.class.getName() + ", " + String.class.getName() + "]"), (Object)props.remove("importedTypes"));
        Assert.assertEquals((Object)"true", (Object)props.remove("concrete"));
        Assert.assertEquals((Object)"io.vertx.test.codegen.testapi", (Object)props.remove("ifacePackageName"));
        Assert.assertEquals((Object)"MethodWithValidVertxGenParams", (Object)props.remove("ifaceSimpleName"));
        Assert.assertEquals((Object)"io.vertx.test.codegen.testapi.MethodWithValidVertxGenParams", (Object)props.remove("ifaceFQCN"));
        Assert.assertEquals((Object)("[" + VertxGenClass1.class.getName() + ", " + VertxGenClass2.class.getName() + "]"), (Object)props.remove("referencedTypes"));
        Assert.assertEquals((Object)"[]", (Object)props.remove("superTypes"));
        Assert.assertEquals((Object)"null", (Object)props.remove("concreteSuperType"));
        Assert.assertEquals((Object)"[]", (Object)props.remove("abstractSuperTypes"));
        Assert.assertEquals((Object)"null", (Object)props.remove("handlerType"));
        Assert.assertEquals((Object)"void", (Object)props.remove("method.methodWithVertxGenParams(str,myParam1,myParam2)"));
    }

    @Test
    public void testDataObjectGen() throws Exception {
        Properties props = this.assertCompile("testgen1", PropertyGettersSetters.class);
        Assert.assertEquals((Object)PropertyGettersSetters.class.getName(), (Object)props.remove("type"));
        Assert.assertEquals((Object)"false", (Object)props.remove("generateConverter"));
        Assert.assertEquals((Object)"false", (Object)props.remove("inheritConverter"));
        Assert.assertEquals((Object)"true", (Object)props.remove("publicConverter"));
        Assert.assertEquals((Object)"false", (Object)props.remove("concrete"));
        Assert.assertEquals((Object)"false", (Object)props.remove("isClass"));
        Assert.assertEquals((Object)("[" + JsonArray.class.getName() + ", " + JsonObject.class.getName() + ", " + Boolean.class.getName() + ", " + Integer.class.getName() + ", " + Long.class.getName() + ", " + String.class.getName() + ", " + Instant.class.getName() + "]"), (Object)props.remove("importedTypes"));
        Assert.assertEquals((Object)"[]", (Object)props.remove("superTypes"));
        Assert.assertEquals((Object)"[]", (Object)props.remove("abstractSuperTypes"));
        Assert.assertEquals((Object)"null", (Object)props.remove("superType"));
        Assert.assertEquals((Object)"io.vertx.test.codegen.testdataobject.ApiObject", (Object)props.remove("property.apiObject"));
        Assert.assertEquals((Object)"io.vertx.test.codegen.testdataobject.ApiObjectWithMapper", (Object)props.remove("property.apiObjectWithMapper"));
        Assert.assertEquals((Object)"java.lang.Boolean", (Object)props.remove("property.boxedBoolean"));
        Assert.assertEquals((Object)"java.lang.Integer", (Object)props.remove("property.boxedInteger"));
        Assert.assertEquals((Object)"java.lang.Long", (Object)props.remove("property.boxedLong"));
        Assert.assertEquals((Object)"io.vertx.test.codegen.testdataobject.EmptyDataObject", (Object)props.remove("property.dataObject"));
        Assert.assertEquals((Object)"io.vertx.test.codegen.testdataobject.Enumerated", (Object)props.remove("property.enumerated"));
        Assert.assertEquals((Object)"io.vertx.core.json.JsonArray", (Object)props.remove("property.jsonArray"));
        Assert.assertEquals((Object)"io.vertx.core.json.JsonObject", (Object)props.remove("property.jsonObject"));
        Assert.assertEquals((Object)"boolean", (Object)props.remove("property.primitiveBoolean"));
        Assert.assertEquals((Object)"int", (Object)props.remove("property.primitiveInteger"));
        Assert.assertEquals((Object)"long", (Object)props.remove("property.primitiveLong"));
        Assert.assertEquals((Object)"java.lang.String", (Object)props.remove("property.string"));
        Assert.assertEquals((Object)"java.time.Instant", (Object)props.remove("property.instant"));
        Assert.assertEquals((Object)"io.vertx.test.codegen.testdataobject.ToJsonDataObject", (Object)props.remove("property.toJsonDataObject"));
        Assert.assertEquals((Object)"false", (Object)props.remove("hasEmptyConstructor"));
        Assert.assertEquals((Object)"false", (Object)props.remove("hasJsonConstructor"));
        Assert.assertEquals((Object)"false", (Object)props.remove("hasToJsonMethod"));
        Assert.assertEquals((Object)"false", (Object)props.remove("serializable"));
        Assert.assertEquals((Object)"false", (Object)props.remove("deserializable"));
    }

    @Test
    public void testEnumGen() throws Exception {
        Properties props = this.assertCompile("testgen1", ValidEnum.class);
        Assert.assertEquals((Object)ValidEnum.class.getName(), (Object)props.remove("type"));
        Assert.assertEquals((Object)"RED,GREEN,BLUE", (Object)props.remove("values"));
    }

    @Test
    public void testModuleGen() throws Exception {
        URL url = CodeGenProcessor.class.getClassLoader().getResource("io/vertx/test/codegen/testmodule/customgroup/package-info.java");
        Compiler compiler = new Compiler((Processor)new CodeGenProcessor());
        compiler.addOption("-Acodegen.generators=testgen1");
        compiler.addOption("-Acodegen.output=" + testDir.getAbsolutePath());
        Assert.assertTrue((boolean)compiler.compile(new File[]{new File(url.toURI())}));
        File f = new File(testDir, "io_vertx_test_codegen_testmodule_customgroup.properties");
        Properties props = new Properties();
        props.load(new FileInputStream(f));
        Assert.assertEquals((Object)"io.vertx.test.codegen.testmodule.customgroup", (Object)props.remove("fqn"));
        Assert.assertEquals((Object)"custom", (Object)props.remove("name"));
    }

    @Test
    public void testIncrementalClass() throws Exception {
        Compiler compiler = new Compiler((Processor)new CodeGenProcessor());
        compiler.addOption("-Acodegen.generators=testgen2");
        compiler.addOption("-Acodegen.output=" + testDir.getAbsolutePath());
        Assert.assertTrue((boolean)compiler.compile(new Class[]{ModuleScopedApi.class, ModuleScopedSubApi.class}));
        File classes = compiler.getClassOutput();
        URLClassLoader loader = new URLClassLoader(new URL[]{classes.toURI().toURL()});
        Class<?> clazz = loader.loadClass("testgen2.incremental_class");
        Callable callable = (Callable)clazz.newInstance();
        Set result = (Set)callable.call();
        HashSet<String> expected = new HashSet<String>();
        expected.add("io.vertx.test.codegen.testmodule.modulescoped.ModuleScopedApi");
        expected.add("io.vertx.test.codegen.testmodule.modulescoped.sub.ModuleScopedSubApi");
        Assert.assertEquals(expected, (Object)result);
    }

    @Test
    public void testAbsoluteFilename() throws Exception {
        Assume.assumeFalse((boolean)System.getProperty("os.name").toLowerCase().contains("win"));
        Compiler compiler = new Compiler((Processor)new CodeGenProcessor());
        compiler.addOption("-Acodegen.generators=testgen3");
        Assert.assertTrue((boolean)compiler.compile(new Class[]{VertxGenClass1.class}));
        File f = new File(testDir, "somedir/file.txt".replace('/', File.separatorChar));
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((boolean)f.isFile());
    }

    @Test
    public void testFileTypes() throws Exception {
        Compiler compiler = new Compiler((Processor)new CodeGenProcessor());
        compiler.setClassOutput(Utils.assertMkDirs(new File(testDir, "classes")));
        compiler.setSourceOutput(Utils.assertMkDirs(new File(testDir, "sources")));
        compiler.addOption("-Acodegen.generators=testgen4");
        compiler.addOption("-Acodegen.output=" + testDir.getAbsolutePath());
        Assert.assertTrue((boolean)compiler.compile(new Class[]{VertxGenClass1.class}));
        Utils.assertFile("should_not_be_compiled", new File(testDir, "sources/file.txt".replace('/', File.separatorChar)));
        Utils.assertFile("should_not_be_compiled", new File(testDir, "classes/file.txt".replace('/', File.separatorChar)));
    }

    @Test
    public void testFileTypesSourceOutputIsClassOutput() throws Exception {
        Compiler compiler = new Compiler((Processor)new CodeGenProcessor());
        compiler.setClassOutput(Utils.assertMkDirs(new File(testDir, "classes")));
        compiler.setSourceOutput(new File(testDir, "classes"));
        compiler.addOption("-Acodegen.generators=testgen4");
        compiler.addOption("-Acodegen.output=" + testDir.getAbsolutePath());
        Assert.assertTrue((boolean)compiler.compile(new Class[]{VertxGenClass1.class}));
        Utils.assertFile("should_not_be_compiled", new File(testDir, "classes/file.txt".replace('/', File.separatorChar)));
    }

    @Test
    public void testFileTypesOverwrite() throws Exception {
        Compiler compiler = new Compiler((Processor)new CodeGenProcessor());
        compiler.setClassOutput(Utils.assertMkDirs(new File(testDir, "classes")));
        compiler.setSourceOutput(Utils.assertMkDirs(new File(testDir, "sources")));
        compiler.addOption("-Acodegen.generators=testgen4");
        compiler.addOption("-Acodegen.output=" + testDir.getAbsolutePath());
        Assert.assertTrue((boolean)compiler.compile(new Class[]{VertxGenClass1.class, VertxGenClass2.class}));
        Utils.assertFile("should_not_be_compiled", new File(testDir, "sources/file.txt".replace('/', File.separatorChar)));
        Utils.assertFile("should_not_be_compiled", new File(testDir, "classes/file.txt".replace('/', File.separatorChar)));
    }

    @Test
    public void testRelocation() throws Exception {
        Compiler compiler = new Compiler((Processor)new CodeGenProcessor());
        compiler.addOption("-Acodegen.generators=testgen5");
        compiler.addOption("-Acodegen.output=" + testDir.getAbsolutePath());
        compiler.addOption("-Acodegen.output.testgen5=foo/bar");
        Assert.assertTrue((boolean)compiler.compile(new Class[]{MethodWithValidVertxGenParams.class, VertxGenClass1.class, VertxGenClass2.class}));
        File f = new File(testDir, "foo/bar/io/vertx/test/codegen/testapi/MethodWithValidVertxGenParams_Other.java".replace('/', File.separatorChar));
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((boolean)f.isFile());
    }

    @Test
    public void testMultipleTypes() throws Exception {
        Compiler compiler = new Compiler((Processor)new CodeGenProcessor());
        compiler.addOption("-Acodegen.generators=testgen6");
        compiler.addOption("-Acodegen.output=" + testDir.getAbsolutePath());
        compiler.addOption("-Acodegen.output.testgen6=foo/bar");
        Assert.assertTrue((boolean)compiler.compile(new Class[]{CommentedDataObject.class, VertxGenClass1.class, VertxGenClass2.class}));
        File f = new File(testDir, "resource/result.txt".replace('/', File.separatorChar));
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((boolean)f.isFile());
        Scanner s = new Scanner(f);
        HashSet<String> fileContent = new HashSet<String>();
        while (s.hasNext()) {
            fileContent.add(s.next());
        }
        s.close();
        Assert.assertTrue((boolean)fileContent.contains(CommentedDataObject.class.getSimpleName()));
        Assert.assertTrue((boolean)fileContent.contains(VertxGenClass1.class.getSimpleName()));
        Assert.assertTrue((boolean)fileContent.contains(VertxGenClass2.class.getSimpleName()));
    }

    @Test
    public void testServiceLoader() throws Exception {
        Properties props = this.assertCompile("testgen7", InvalidInterfaceDataObject.class);
        Assert.assertEquals((Object)props.remove("MyGenerator"), (Object)"true");
    }

    public static String testAbsoluteFilenamePath() {
        return testDir.getAbsolutePath().replace(File.separatorChar, '/') + "/somedir/file.txt";
    }
}

