/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class NameTest {
    @Test
    public void testPrimitive() {
        Assert.assertEquals((Object)"int", (Object)Integer.TYPE.getName());
        Assert.assertEquals((Object)"int", (Object)Integer.TYPE.getCanonicalName());
        Assert.assertEquals((Object)"int", (Object)Integer.TYPE.getTypeName());
        Assert.assertEquals((Object)"int", (Object)Integer.TYPE.getSimpleName());
    }

    @Test
    public void testPrimitiveArray() {
        Assert.assertEquals((Object)"[I", (Object)int[].class.getName());
        Assert.assertEquals((Object)"int[]", (Object)int[].class.getCanonicalName());
        Assert.assertEquals((Object)"int[]", (Object)int[].class.getTypeName());
        Assert.assertEquals((Object)"int[]", (Object)int[].class.getSimpleName());
    }

    @Test
    public void testClass() {
        Assert.assertEquals((Object)"java.util.Locale", (Object)Locale.class.getName());
        Assert.assertEquals((Object)"java.util.Locale", (Object)Locale.class.getCanonicalName());
        Assert.assertEquals((Object)"java.util.Locale", (Object)Locale.class.getTypeName());
        Assert.assertEquals((Object)"Locale", (Object)Locale.class.getSimpleName());
    }

    @Test
    public void testClassArray() {
        Assert.assertEquals((Object)"[Ljava.util.Locale;", (Object)Locale[].class.getName());
        Assert.assertEquals((Object)"java.util.Locale[]", (Object)Locale[].class.getCanonicalName());
        Assert.assertEquals((Object)"java.util.Locale[]", (Object)Locale[].class.getTypeName());
        Assert.assertEquals((Object)"Locale[]", (Object)Locale[].class.getSimpleName());
    }

    @Test
    public void testGenericClass() {
        Assert.assertEquals((Object)"java.util.List", (Object)List.class.getName());
        Assert.assertEquals((Object)"java.util.List", (Object)List.class.getCanonicalName());
        Assert.assertEquals((Object)"java.util.List", (Object)List.class.getTypeName());
        Assert.assertEquals((Object)"List", (Object)List.class.getSimpleName());
    }

    @Test
    public void testParameterizedType() {
        abstract class MapOfSomething<V>
        implements Map<String, V> {
            MapOfSomething() {
            }
        }
        Type type = MapOfSomething.class.getGenericInterfaces()[0];
        Assert.assertEquals((Object)"java.util.Map<java.lang.String, V>", (Object)type.getTypeName());
    }

    @Test
    public void testTypeVariable() throws Exception {
        abstract class Something<T> {
            T t;

            Something() {
            }
        }
        Type type = Something.class.getDeclaredField("t").getGenericType();
        Assert.assertEquals((Object)"T", (Object)type.getTypeName());
    }
}

