/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.EnumModel;
import io.vertx.codegen.EnumValueInfo;
import io.vertx.codegen.GenException;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.type.AnnotationValueInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.test.codegen.ClassTestBase;
import io.vertx.test.codegen.GeneratorHelper;
import io.vertx.test.codegen.TypeLiteral;
import io.vertx.test.codegen.testapi.jsonmapper.MyEnumWithCustomFactory;
import io.vertx.test.codegen.testapi.jsonmapper.WithMyCustomEnumWithMapper;
import io.vertx.test.codegen.testenum.EnumAsParam;
import io.vertx.test.codegen.testenum.InvalidEmptyEnum;
import io.vertx.test.codegen.testenum.ValidEnum;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class EnumTest
extends ClassTestBase {
    @Test
    public void testEnum() throws Exception {
        EnumModel model = new GeneratorHelper().generateEnum(ValidEnum.class, new Class[0]);
        Assert.assertEquals(Arrays.asList("RED", "GREEN", "BLUE"), model.getValues().stream().map(EnumValueInfo::getIdentifier).collect(Collectors.toList()));
        Assert.assertEquals(Arrays.asList("RED doc", "GREEN doc", "BLUE doc"), model.getValues().stream().map(e -> e.getDoc().toString()).collect(Collectors.toList()));
        Assert.assertEquals((Object)"enum", (Object)model.getKind());
        Assert.assertEquals((Object)"ValidEnum doc", (Object)model.getDoc().toString());
        Assert.assertEquals((Object)ValidEnum.class.getName(), (Object)model.getFqn());
        Assert.assertEquals((Object)"dummy", (Object)model.getModule().getName());
        Assert.assertTrue((boolean)model.getType().isGen());
    }

    @Test
    public void testJsonMapper() throws Exception {
        ClassModel model = new GeneratorHelper().registerConverter(MyEnumWithCustomFactory.class, WithMyCustomEnumWithMapper.class.getName(), "serializeMyEnumWithCustomFactory").registerConverter(MyEnumWithCustomFactory.class, WithMyCustomEnumWithMapper.class.getName(), "deserializeMyEnumWithCustomFactory").generateClass(WithMyCustomEnumWithMapper.class, new Class[0]);
        Assert.assertFalse((boolean)model.getAnnotations().isEmpty());
        Assert.assertEquals((long)1L, (long)model.getAnnotations().size());
        Assert.assertEquals((Object)VertxGen.class.getName(), (Object)((AnnotationValueInfo)model.getAnnotations().get(0)).getName());
        Assert.assertEquals((long)1L, (long)model.getReferencedDataObjectTypes().size());
        Assert.assertEquals((Object)"MyEnumWithCustomFactory", (Object)((ClassTypeInfo)model.getReferencedDataObjectTypes().iterator().next()).getSimpleName());
        this.checkMethod((MethodInfo)((List)model.getMethodMap().get("returnMyEnumWithCustomFactory")).get(0), "returnMyEnumWithCustomFactory", 0, new TypeLiteral<MyEnumWithCustomFactory>(){}, MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        MethodInfo myPojoParam = (MethodInfo)((List)model.getMethodMap().get("setMyEnumWithCustomFactory")).get(0);
        this.checkMethod(myPojoParam, "setMyEnumWithCustomFactory", 1, "void", MethodKind.OTHER, new ClassTestBase.MethodCheck[0]);
        this.checkParam(myPojoParam.getParam(0), "myEnum", MyEnumWithCustomFactory.class.getName(), ClassKind.ENUM);
    }

    @Test
    public void testInvalidEmptyEnum() throws Exception {
        try {
            new GeneratorHelper().generateEnum(InvalidEmptyEnum.class, new Class[0]);
            Assert.fail();
        }
        catch (GenException genException) {
            // empty catch block
        }
    }

    @Test
    public void testEnumListingFromApi() throws Exception {
        ClassModel model = new GeneratorHelper().generateClass(EnumAsParam.class, new Class[0]);
        Assert.assertTrue((model.getReferencedEnumTypes().size() > 0 ? 1 : 0) != 0);
        TypeInfo typeInfo = (TypeInfo)model.getReferencedEnumTypes().toArray()[0];
        Assert.assertTrue((boolean)(typeInfo instanceof EnumTypeInfo));
        Assert.assertEquals((Object)"ValidEnum", (Object)typeInfo.getSimpleName());
    }
}

