/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.shiro.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.shiro.ShiroAuth;
import io.vertx.ext.auth.shiro.ShiroAuthOptions;
import io.vertx.ext.auth.shiro.impl.LDAPAuthProvider;
import io.vertx.ext.auth.shiro.impl.PropertiesAuthProvider;
import java.util.Objects;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.GetAuthorizationsHack;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.subject.support.DefaultSubjectContext;

@Deprecated
public class ShiroAuthProviderImpl
implements ShiroAuth {
    private final Vertx vertx;
    private final SecurityManager securityManager;
    private final String realmName;

    public static ShiroAuth create(Vertx vertx, ShiroAuthOptions options) {
        Realm realm;
        switch (options.getType()) {
            case PROPERTIES: {
                realm = PropertiesAuthProvider.createRealm(options.getConfig());
                break;
            }
            case LDAP: {
                realm = LDAPAuthProvider.createRealm(options.getConfig());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid shiro auth realm type: " + (Object)((Object)options.getType()));
            }
        }
        return new ShiroAuthProviderImpl(vertx, realm);
    }

    public ShiroAuthProviderImpl(Vertx vertx, Realm realm) {
        this.vertx = vertx;
        this.securityManager = new DefaultSecurityManager(realm);
        this.realmName = realm.getName();
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate((Credentials)new UsernamePasswordCredentials(authInfo), resultHandler);
    }

    public void authenticate(Credentials credentials, Handler<AsyncResult<User>> resultHandler) {
        try {
            UsernamePasswordCredentials authInfo = (UsernamePasswordCredentials)credentials;
            authInfo.checkValid(null);
            this.vertx.executeBlocking(fut -> {
                SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
                DefaultSubjectContext subjectContext = new DefaultSubjectContext();
                Subject subject = this.securityManager.createSubject((SubjectContext)subjectContext);
                String username = authInfo.getUsername();
                String password = authInfo.getPassword();
                UsernamePasswordToken token = new UsernamePasswordToken(username, password);
                try {
                    subject.login((AuthenticationToken)token);
                    fut.complete((Object)this.createUser(this.securityManager, subject));
                }
                catch (AuthenticationException e) {
                    fut.fail((Throwable)e);
                }
            }, resultHandler);
        }
        catch (RuntimeException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    Vertx getVertx() {
        return this.vertx;
    }

    SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    String getRealmName() {
        return this.realmName;
    }

    private User createUser(SecurityManager securityManager, Subject subject) {
        Objects.requireNonNull(securityManager);
        Objects.requireNonNull(subject);
        JsonObject principal = new JsonObject().put("username", (Object)subject.getPrincipal().toString());
        User result = User.create((JsonObject)principal);
        result.authorizations().add("shiro-authentication", GetAuthorizationsHack.getAuthorizations(securityManager, subject));
        return result;
    }
}

