/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import java.net.URI;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;

class AuthorizationPreservingHttpClient
extends HttpClient {
    private static final String PRESERVE_AUTHORIZATION_KEY = "airlift_preserve_authorization";

    public AuthorizationPreservingHttpClient(HttpClientTransport transport) {
        super(transport);
    }

    protected Request copyRequest(HttpRequest oldRequest, URI newUri) {
        Request newRequest = super.copyRequest(oldRequest, newUri);
        if (AuthorizationPreservingHttpClient.isPreserveAuthorization((Request)oldRequest)) {
            AuthorizationPreservingHttpClient.setPreserveAuthorization(newRequest, true);
            for (HttpField field : oldRequest.getHeaders().getFields(HttpHeader.AUTHORIZATION)) {
                newRequest.headers(headers -> headers.add(field));
            }
        }
        return newRequest;
    }

    public static void setPreserveAuthorization(Request request, boolean preserveAuthorization) {
        request.attribute(PRESERVE_AUTHORIZATION_KEY, (Object)preserveAuthorization);
    }

    private static boolean isPreserveAuthorization(Request request) {
        return Boolean.TRUE.equals(request.getAttributes().get(PRESERVE_AUTHORIZATION_KEY));
    }
}

