/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.MalformedInputException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Supplier;

public class ThreadLocalCompressorDecompressor
implements Compressor,
Decompressor {
    private final ThreadLocal<Compressor> compressor;
    private final ThreadLocal<Decompressor> decompressor;

    public ThreadLocalCompressorDecompressor(Supplier<Compressor> compressorFactory, Supplier<Decompressor> decompressorFactory) {
        this.compressor = ThreadLocal.withInitial(Objects.requireNonNull(compressorFactory, "compressorFactory is null"));
        this.decompressor = ThreadLocal.withInitial(Objects.requireNonNull(decompressorFactory, "decompressorFactory is null"));
    }

    public int maxCompressedLength(int uncompressedSize) {
        return this.compressor.get().maxCompressedLength(uncompressedSize);
    }

    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        return this.compressor.get().compress(input, inputOffset, inputLength, output, outputOffset, maxOutputLength);
    }

    public void compress(ByteBuffer input, ByteBuffer output) {
        this.compressor.get().compress(input, output);
    }

    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        return this.decompressor.get().decompress(input, inputOffset, inputLength, output, outputOffset, maxOutputLength);
    }

    public void decompress(ByteBuffer input, ByteBuffer output) throws MalformedInputException {
        this.decompressor.get().decompress(input, output);
    }
}

