/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.ColorFunctions;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractIntType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.HexFormat;

public class ColorType
extends AbstractIntType {
    private static final HexFormat HEX_FORMAT = HexFormat.of();
    public static final ColorType COLOR = new ColorType();
    public static final String NAME = "color";

    private ColorType() {
        super(new TypeSignature(NAME, new TypeSignatureParameter[0]));
    }

    public boolean isOrderable() {
        return false;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        int color = block.getInt(position, 0);
        if (color < 0) {
            return ColorFunctions.SystemColor.valueOf(-(color + 1)).getName();
        }
        StringBuilder builder = new StringBuilder(7).append('#');
        HEX_FORMAT.toHexDigits(builder, (byte)(color >> 16 & 0xFF));
        HEX_FORMAT.toHexDigits(builder, (byte)(color >> 8 & 0xFF));
        HEX_FORMAT.toHexDigits(builder, (byte)(color & 0xFF));
        return builder.toString();
    }

    public boolean equals(Object other) {
        return other == COLOR;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

