/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tracing;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import io.trino.tracing.ForTracing;
import io.trino.tracing.ScopedSpan;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TracingAccessControl
implements AccessControl {
    private final Tracer tracer;
    private final AccessControl delegate;

    @Inject
    public TracingAccessControl(Tracer tracer, @ForTracing AccessControl delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
    }

    @VisibleForTesting
    public AccessControl getDelegate() {
        return this.delegate;
    }

    @Override
    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        Span span = this.startSpan("checkCanSetUser");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanSetUser(principal, userName);
        }
    }

    @Override
    public void checkCanImpersonateUser(Identity identity, String userName) {
        Span span = this.startSpan("checkCanImpersonateUser");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanImpersonateUser(identity, userName);
        }
    }

    @Override
    public void checkCanReadSystemInformation(Identity identity) {
        Span span = this.startSpan("checkCanReadSystemInformation");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanReadSystemInformation(identity);
        }
    }

    @Override
    public void checkCanWriteSystemInformation(Identity identity) {
        Span span = this.startSpan("checkCanWriteSystemInformation");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanWriteSystemInformation(identity);
        }
    }

    @Override
    public void checkCanExecuteQuery(Identity identity) {
        Span span = this.startSpan("checkCanExecuteQuery");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanExecuteQuery(identity);
        }
    }

    @Override
    public void checkCanViewQueryOwnedBy(Identity identity, Identity queryOwner) {
        Span span = this.startSpan("checkCanViewQueryOwnedBy");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanViewQueryOwnedBy(identity, queryOwner);
        }
    }

    @Override
    public Collection<Identity> filterQueriesOwnedBy(Identity identity, Collection<Identity> queryOwners) {
        Span span = this.startSpan("filterQueriesOwnedBy");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Collection<Identity> collection = this.delegate.filterQueriesOwnedBy(identity, queryOwners);
            return collection;
        }
    }

    @Override
    public void checkCanKillQueryOwnedBy(Identity identity, Identity queryOwner) {
        Span span = this.startSpan("checkCanKillQueryOwnedBy");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanKillQueryOwnedBy(identity, queryOwner);
        }
    }

    @Override
    public void checkCanCreateCatalog(SecurityContext context, String catalog) {
        Span span = this.startSpan("checkCanCreateCatalog");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanCreateCatalog(context, catalog);
        }
    }

    @Override
    public void checkCanDropCatalog(SecurityContext context, String catalog) {
        Span span = this.startSpan("checkCanDropCatalog");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanDropCatalog(context, catalog);
        }
    }

    @Override
    public Set<String> filterCatalogs(SecurityContext context, Set<String> catalogs) {
        Span span = this.startSpan("filterCatalogs");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Set<String> set = this.delegate.filterCatalogs(context, catalogs);
            return set;
        }
    }

    @Override
    public void checkCanCreateSchema(SecurityContext context, CatalogSchemaName schemaName, Map<String, Object> properties) {
        Span span = this.startSpan("checkCanCreateSchema");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanCreateSchema(context, schemaName, properties);
        }
    }

    @Override
    public void checkCanDropSchema(SecurityContext context, CatalogSchemaName schemaName) {
        Span span = this.startSpan("checkCanDropSchema");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanDropSchema(context, schemaName);
        }
    }

    @Override
    public void checkCanRenameSchema(SecurityContext context, CatalogSchemaName schemaName, String newSchemaName) {
        Span span = this.startSpan("checkCanRenameSchema");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanRenameSchema(context, schemaName, newSchemaName);
        }
    }

    @Override
    public void checkCanSetSchemaAuthorization(SecurityContext context, CatalogSchemaName schemaName, TrinoPrincipal principal) {
        Span span = this.startSpan("checkCanSetSchemaAuthorization");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanSetSchemaAuthorization(context, schemaName, principal);
        }
    }

    @Override
    public void checkCanShowSchemas(SecurityContext context, String catalogName) {
        Span span = this.startSpan("checkCanShowSchemas");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanShowSchemas(context, catalogName);
        }
    }

    @Override
    public Set<String> filterSchemas(SecurityContext context, String catalogName, Set<String> schemaNames) {
        Span span = this.startSpan("filterSchemas");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Set<String> set = this.delegate.filterSchemas(context, catalogName, schemaNames);
            return set;
        }
    }

    @Override
    public void checkCanShowCreateSchema(SecurityContext context, CatalogSchemaName schemaName) {
        Span span = this.startSpan("checkCanShowCreateSchema");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanShowCreateSchema(context, schemaName);
        }
    }

    @Override
    public void checkCanShowCreateTable(SecurityContext context, QualifiedObjectName tableName) {
        Span span = this.startSpan("checkCanShowCreateTable");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanShowCreateTable(context, tableName);
        }
    }

    @Override
    public void checkCanCreateTable(SecurityContext context, QualifiedObjectName tableName, Map<String, Object> properties) {
        Span span = this.startSpan("checkCanCreateTable");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanCreateTable(context, tableName, properties);
        }
    }

    @Override
    public void checkCanDropTable(SecurityContext context, QualifiedObjectName tableName) {
        Span span = this.startSpan("checkCanDropTable");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanDropTable(context, tableName);
        }
    }

    @Override
    public void checkCanRenameTable(SecurityContext context, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        Span span = this.startSpan("checkCanRenameTable");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanRenameTable(context, tableName, newTableName);
        }
    }

    @Override
    public void checkCanSetTableProperties(SecurityContext context, QualifiedObjectName tableName, Map<String, Optional<Object>> properties) {
        Span span = this.startSpan("checkCanSetTableProperties");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanSetTableProperties(context, tableName, properties);
        }
    }

    @Override
    public void checkCanSetTableComment(SecurityContext context, QualifiedObjectName tableName) {
        Span span = this.startSpan("checkCanSetTableComment");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanSetTableComment(context, tableName);
        }
    }

    @Override
    public void checkCanSetViewComment(SecurityContext context, QualifiedObjectName viewName) {
        Span span = this.startSpan("checkCanSetViewComment");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanSetViewComment(context, viewName);
        }
    }

    @Override
    public void checkCanSetColumnComment(SecurityContext context, QualifiedObjectName tableName) {
        Span span = this.startSpan("checkCanSetColumnComment");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanSetColumnComment(context, tableName);
        }
    }

    @Override
    public void checkCanShowTables(SecurityContext context, CatalogSchemaName schema) {
        Span span = this.startSpan("checkCanShowTables");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanShowTables(context, schema);
        }
    }

    @Override
    public Set<SchemaTableName> filterTables(SecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        Span span = this.startSpan("filterTables");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Set<SchemaTableName> set = this.delegate.filterTables(context, catalogName, tableNames);
            return set;
        }
    }

    @Override
    public void checkCanShowColumns(SecurityContext context, CatalogSchemaTableName table) {
        Span span = this.startSpan("checkCanShowColumns");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanShowColumns(context, table);
        }
    }

    @Override
    public Set<String> filterColumns(SecurityContext context, CatalogSchemaTableName tableName, Set<String> columns) {
        Span span = this.startSpan("filterColumns");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Set<String> set = this.delegate.filterColumns(context, tableName, columns);
            return set;
        }
    }

    @Override
    public void checkCanAddColumns(SecurityContext context, QualifiedObjectName tableName) {
        Span span = this.startSpan("checkCanAddColumns");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanAddColumns(context, tableName);
        }
    }

    @Override
    public void checkCanDropColumn(SecurityContext context, QualifiedObjectName tableName) {
        Span span = this.startSpan("checkCanDropColumn");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanDropColumn(context, tableName);
        }
    }

    @Override
    public void checkCanAlterColumn(SecurityContext context, QualifiedObjectName tableName) {
        Span span = this.startSpan("checkCanAlterColumn");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanAlterColumn(context, tableName);
        }
    }

    @Override
    public void checkCanSetTableAuthorization(SecurityContext context, QualifiedObjectName tableName, TrinoPrincipal principal) {
        Span span = this.startSpan("checkCanSetTableAuthorization");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanSetTableAuthorization(context, tableName, principal);
        }
    }

    @Override
    public void checkCanRenameColumn(SecurityContext context, QualifiedObjectName tableName) {
        Span span = this.startSpan("checkCanRenameColumn");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanRenameColumn(context, tableName);
        }
    }

    @Override
    public void checkCanInsertIntoTable(SecurityContext context, QualifiedObjectName tableName) {
        Span span = this.startSpan("checkCanInsertIntoTable");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanInsertIntoTable(context, tableName);
        }
    }

    @Override
    public void checkCanDeleteFromTable(SecurityContext context, QualifiedObjectName tableName) {
        Span span = this.startSpan("checkCanDeleteFromTable");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanDeleteFromTable(context, tableName);
        }
    }

    @Override
    public void checkCanTruncateTable(SecurityContext context, QualifiedObjectName tableName) {
        Span span = this.startSpan("checkCanTruncateTable");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanTruncateTable(context, tableName);
        }
    }

    @Override
    public void checkCanUpdateTableColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> updatedColumnNames) {
        Span span = this.startSpan("checkCanUpdateTableColumns");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanUpdateTableColumns(context, tableName, updatedColumnNames);
        }
    }

    @Override
    public void checkCanCreateView(SecurityContext context, QualifiedObjectName viewName) {
        Span span = this.startSpan("checkCanCreateView");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanCreateView(context, viewName);
        }
    }

    @Override
    public void checkCanRenameView(SecurityContext context, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        Span span = this.startSpan("checkCanRenameView");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanRenameView(context, viewName, newViewName);
        }
    }

    @Override
    public void checkCanSetViewAuthorization(SecurityContext context, QualifiedObjectName view, TrinoPrincipal principal) {
        Span span = this.startSpan("checkCanSetViewAuthorization");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanSetViewAuthorization(context, view, principal);
        }
    }

    @Override
    public void checkCanDropView(SecurityContext context, QualifiedObjectName viewName) {
        Span span = this.startSpan("checkCanDropView");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanDropView(context, viewName);
        }
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        Span span = this.startSpan("checkCanCreateViewWithSelectFromColumns");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanCreateViewWithSelectFromColumns(context, tableName, columnNames);
        }
    }

    @Override
    public void checkCanCreateMaterializedView(SecurityContext context, QualifiedObjectName materializedViewName, Map<String, Object> properties) {
        Span span = this.startSpan("checkCanCreateMaterializedView");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanCreateMaterializedView(context, materializedViewName, properties);
        }
    }

    @Override
    public void checkCanRefreshMaterializedView(SecurityContext context, QualifiedObjectName materializedViewName) {
        Span span = this.startSpan("checkCanRefreshMaterializedView");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanRefreshMaterializedView(context, materializedViewName);
        }
    }

    @Override
    public void checkCanDropMaterializedView(SecurityContext context, QualifiedObjectName materializedViewName) {
        Span span = this.startSpan("checkCanDropMaterializedView");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanDropMaterializedView(context, materializedViewName);
        }
    }

    @Override
    public void checkCanRenameMaterializedView(SecurityContext context, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        Span span = this.startSpan("checkCanRenameMaterializedView");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanRenameMaterializedView(context, viewName, newViewName);
        }
    }

    @Override
    public void checkCanSetMaterializedViewProperties(SecurityContext context, QualifiedObjectName materializedViewName, Map<String, Optional<Object>> properties) {
        Span span = this.startSpan("checkCanSetMaterializedViewProperties");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanSetMaterializedViewProperties(context, materializedViewName, properties);
        }
    }

    @Override
    public void checkCanGrantExecuteFunctionPrivilege(SecurityContext context, String functionName, Identity grantee, boolean grantOption) {
        Span span = this.startSpan("checkCanGrantExecuteFunctionPrivilege");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanGrantExecuteFunctionPrivilege(context, functionName, grantee, grantOption);
        }
    }

    @Override
    public void checkCanGrantExecuteFunctionPrivilege(SecurityContext context, FunctionKind functionKind, QualifiedObjectName functionName, Identity grantee, boolean grantOption) {
        Span span = this.startSpan("checkCanGrantExecuteFunctionPrivilege");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanGrantExecuteFunctionPrivilege(context, functionKind, functionName, grantee, grantOption);
        }
    }

    @Override
    public void checkCanGrantSchemaPrivilege(SecurityContext context, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal grantee, boolean grantOption) {
        Span span = this.startSpan("checkCanGrantSchemaPrivilege");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanGrantSchemaPrivilege(context, privilege, schemaName, grantee, grantOption);
        }
    }

    @Override
    public void checkCanDenySchemaPrivilege(SecurityContext context, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal grantee) {
        Span span = this.startSpan("checkCanDenySchemaPrivilege");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanDenySchemaPrivilege(context, privilege, schemaName, grantee);
        }
    }

    @Override
    public void checkCanRevokeSchemaPrivilege(SecurityContext context, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal revokee, boolean grantOption) {
        Span span = this.startSpan("checkCanRevokeSchemaPrivilege");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanRevokeSchemaPrivilege(context, privilege, schemaName, revokee, grantOption);
        }
    }

    @Override
    public void checkCanGrantTablePrivilege(SecurityContext context, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal grantee, boolean grantOption) {
        Span span = this.startSpan("checkCanGrantTablePrivilege");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanGrantTablePrivilege(context, privilege, tableName, grantee, grantOption);
        }
    }

    @Override
    public void checkCanDenyTablePrivilege(SecurityContext context, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal grantee) {
        Span span = this.startSpan("checkCanDenyTablePrivilege");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanDenyTablePrivilege(context, privilege, tableName, grantee);
        }
    }

    @Override
    public void checkCanRevokeTablePrivilege(SecurityContext context, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal revokee, boolean grantOption) {
        Span span = this.startSpan("checkCanRevokeTablePrivilege");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanRevokeTablePrivilege(context, privilege, tableName, revokee, grantOption);
        }
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        Span span = this.startSpan("checkCanSetSystemSessionProperty");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanSetSystemSessionProperty(identity, propertyName);
        }
    }

    @Override
    public void checkCanSetCatalogSessionProperty(SecurityContext context, String catalogName, String propertyName) {
        Span span = this.startSpan("checkCanSetCatalogSessionProperty");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanSetCatalogSessionProperty(context, catalogName, propertyName);
        }
    }

    @Override
    public void checkCanSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        Span span = this.startSpan("checkCanSelectFromColumns");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanSelectFromColumns(context, tableName, columnNames);
        }
    }

    @Override
    public void checkCanCreateRole(SecurityContext context, String role, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        Span span = this.startSpan("checkCanCreateRole");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanCreateRole(context, role, grantor, catalogName);
        }
    }

    @Override
    public void checkCanDropRole(SecurityContext context, String role, Optional<String> catalogName) {
        Span span = this.startSpan("checkCanDropRole");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanDropRole(context, role, catalogName);
        }
    }

    @Override
    public void checkCanGrantRoles(SecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        Span span = this.startSpan("checkCanGrantRoles");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanGrantRoles(context, roles, grantees, adminOption, grantor, catalogName);
        }
    }

    @Override
    public void checkCanRevokeRoles(SecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        Span span = this.startSpan("checkCanRevokeRoles");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanRevokeRoles(context, roles, grantees, adminOption, grantor, catalogName);
        }
    }

    @Override
    public void checkCanSetCatalogRole(SecurityContext context, String role, String catalogName) {
        Span span = this.startSpan("checkCanSetCatalogRole");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanSetCatalogRole(context, role, catalogName);
        }
    }

    @Override
    public void checkCanShowRoleAuthorizationDescriptors(SecurityContext context, Optional<String> catalogName) {
        Span span = this.startSpan("checkCanShowRoleAuthorizationDescriptors");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanShowRoleAuthorizationDescriptors(context, catalogName);
        }
    }

    @Override
    public void checkCanShowRoles(SecurityContext context, Optional<String> catalogName) {
        Span span = this.startSpan("checkCanShowRoles");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanShowRoles(context, catalogName);
        }
    }

    @Override
    public void checkCanShowCurrentRoles(SecurityContext context, Optional<String> catalogName) {
        Span span = this.startSpan("checkCanShowCurrentRoles");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanShowCurrentRoles(context, catalogName);
        }
    }

    @Override
    public void checkCanShowRoleGrants(SecurityContext context, Optional<String> catalogName) {
        Span span = this.startSpan("checkCanShowRoleGrants");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanShowRoleGrants(context, catalogName);
        }
    }

    @Override
    public void checkCanExecuteProcedure(SecurityContext context, QualifiedObjectName procedureName) {
        Span span = this.startSpan("checkCanExecuteProcedure");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanExecuteProcedure(context, procedureName);
        }
    }

    @Override
    public void checkCanExecuteFunction(SecurityContext context, String functionName) {
        Span span = this.startSpan("checkCanExecuteFunction");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanExecuteFunction(context, functionName);
        }
    }

    @Override
    public void checkCanExecuteFunction(SecurityContext context, FunctionKind functionKind, QualifiedObjectName functionName) {
        Span span = this.startSpan("checkCanExecuteFunction");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanExecuteFunction(context, functionKind, functionName);
        }
    }

    @Override
    public void checkCanExecuteTableProcedure(SecurityContext context, QualifiedObjectName tableName, String procedureName) {
        Span span = this.startSpan("checkCanExecuteTableProcedure");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.checkCanExecuteTableProcedure(context, tableName, procedureName);
        }
    }

    @Override
    public List<ViewExpression> getRowFilters(SecurityContext context, QualifiedObjectName tableName) {
        Span span = this.startSpan("getRowFilters");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            List<ViewExpression> list = this.delegate.getRowFilters(context, tableName);
            return list;
        }
    }

    @Override
    public Optional<ViewExpression> getColumnMask(SecurityContext context, QualifiedObjectName tableName, String columnName, Type type) {
        Span span = this.startSpan("getColumnMask");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<ViewExpression> optional = this.delegate.getColumnMask(context, tableName, columnName, type);
            return optional;
        }
    }

    private Span startSpan(String methodName) {
        return this.tracer.spanBuilder("AccessControl." + methodName).startSpan();
    }
}

