/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;

public class TestingSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(TestingSplit.class);
    private static final HostAddress localHost = HostAddress.fromString((String)"127.0.0.1");
    private final boolean remotelyAccessible;
    private final List<HostAddress> addresses;

    public static TestingSplit createLocalSplit() {
        return new TestingSplit(false, (List<HostAddress>)ImmutableList.of((Object)localHost));
    }

    public static TestingSplit createEmptySplit() {
        return new TestingSplit(false, (List<HostAddress>)ImmutableList.of());
    }

    public static TestingSplit createRemoteSplit() {
        return new TestingSplit(true, (List<HostAddress>)ImmutableList.of());
    }

    @JsonCreator
    public TestingSplit(@JsonProperty(value="remotelyAccessible") boolean remotelyAccessible, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        this.addresses = addresses;
        this.remotelyAccessible = remotelyAccessible;
    }

    @JsonProperty
    public boolean isRemotelyAccessible() {
        return this.remotelyAccessible;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes);
    }
}

