/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.trino.cost.PlanNodeStatsAndCostSummary;
import io.trino.sql.planner.planprinter.NodeRepresentation;
import io.trino.sql.planner.planprinter.PlanRepresentation;
import io.trino.sql.planner.planprinter.Renderer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JsonRenderer
implements Renderer<String> {
    private static final JsonCodec<JsonRenderedNode> CODEC = JsonCodec.jsonCodec(JsonRenderedNode.class);

    @Override
    public String render(PlanRepresentation plan) {
        return CODEC.toJson((Object)this.renderJson(plan, plan.getRoot()));
    }

    protected JsonRenderedNode renderJson(PlanRepresentation plan, NodeRepresentation node) {
        List children = (List)node.getChildren().stream().map(plan::getNode).filter(Optional::isPresent).map(Optional::get).map(n -> this.renderJson(plan, (NodeRepresentation)n)).collect(ImmutableList.toImmutableList());
        return new JsonRenderedNode(node.getId().toString(), node.getName(), node.getDescriptor(), node.getOutputs(), node.getDetails(), node.getEstimates(plan.getTypes()), children);
    }

    public static class JsonRenderedNode {
        private final String id;
        private final String name;
        private final Map<String, String> descriptor;
        private final List<NodeRepresentation.TypedSymbol> outputs;
        private final List<String> details;
        private final List<PlanNodeStatsAndCostSummary> estimates;
        private final List<JsonRenderedNode> children;

        public JsonRenderedNode(String id, String name, Map<String, String> descriptor, List<NodeRepresentation.TypedSymbol> outputs, List<String> details, List<PlanNodeStatsAndCostSummary> estimates, List<JsonRenderedNode> children) {
            this.id = Objects.requireNonNull(id, "id is null");
            this.name = Objects.requireNonNull(name, "name is null");
            this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
            this.outputs = Objects.requireNonNull(outputs, "outputs is null");
            this.details = Objects.requireNonNull(details, "details is null");
            this.estimates = Objects.requireNonNull(estimates, "estimates is null");
            this.children = Objects.requireNonNull(children, "children is null");
        }

        @JsonProperty
        public String getId() {
            return this.id;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public Map<String, String> getDescriptor() {
            return this.descriptor;
        }

        @JsonProperty
        public List<NodeRepresentation.TypedSymbol> getOutputs() {
            return this.outputs;
        }

        @JsonProperty
        public List<String> getDetails() {
            return this.details;
        }

        @JsonProperty
        public List<PlanNodeStatsAndCostSummary> getEstimates() {
            return this.estimates;
        }

        @JsonProperty
        public List<JsonRenderedNode> getChildren() {
            return this.children;
        }
    }
}

