/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.StatisticAggregations;
import io.trino.sql.planner.plan.StatisticAggregationsDescriptor;
import io.trino.sql.planner.plan.TableWriterNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class TableFinishNode
extends PlanNode {
    private final PlanNode source;
    private final TableWriterNode.WriterTarget target;
    private final Symbol rowCountSymbol;
    private final Optional<StatisticAggregations> statisticsAggregation;
    private final Optional<StatisticAggregationsDescriptor<Symbol>> statisticsAggregationDescriptor;

    @JsonCreator
    public TableFinishNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") TableWriterNode.WriterTarget target, @JsonProperty(value="rowCountSymbol") Symbol rowCountSymbol, @JsonProperty(value="statisticsAggregation") Optional<StatisticAggregations> statisticsAggregation, @JsonProperty(value="statisticsAggregationDescriptor") Optional<StatisticAggregationsDescriptor<Symbol>> statisticsAggregationDescriptor) {
        super(id);
        Preconditions.checkArgument((target != null || source instanceof TableWriterNode ? 1 : 0) != 0);
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.rowCountSymbol = Objects.requireNonNull(rowCountSymbol, "rowCountSymbol is null");
        this.statisticsAggregation = Objects.requireNonNull(statisticsAggregation, "statisticsAggregation is null");
        this.statisticsAggregationDescriptor = Objects.requireNonNull(statisticsAggregationDescriptor, "statisticsAggregationDescriptor is null");
        Preconditions.checkArgument((statisticsAggregation.isPresent() == statisticsAggregationDescriptor.isPresent() ? 1 : 0) != 0, (Object)"statisticsAggregation and statisticsAggregationDescriptor must both be either present or absent");
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public TableWriterNode.WriterTarget getTarget() {
        return this.target;
    }

    @JsonProperty
    public Symbol getRowCountSymbol() {
        return this.rowCountSymbol;
    }

    @JsonProperty
    public Optional<StatisticAggregations> getStatisticsAggregation() {
        return this.statisticsAggregation;
    }

    @JsonProperty
    public Optional<StatisticAggregationsDescriptor<Symbol>> getStatisticsAggregationDescriptor() {
        return this.statisticsAggregationDescriptor;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.of((Object)this.rowCountSymbol);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableFinish(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new TableFinishNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.target, this.rowCountSymbol, this.statisticsAggregation, this.statisticsAggregationDescriptor);
    }
}

