/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.trino.metadata.QualifiedObjectName;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Objects;

@Immutable
public class RefreshMaterializedViewNode
extends PlanNode {
    private final QualifiedObjectName viewName;

    @JsonCreator
    public RefreshMaterializedViewNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="viewName") QualifiedObjectName viewName) {
        super(id);
        this.viewName = Objects.requireNonNull(viewName, "viewName is null");
    }

    @JsonProperty
    public QualifiedObjectName getViewName() {
        return this.viewName;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.of();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitRefreshMaterializedView(this, context);
    }
}

