/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.Streams;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Row;

public class TransformCorrelatedSingleRowSubqueryToProject
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Patterns.CorrelatedJoin.filter().equalTo((Object)BooleanLiteral.TRUE_LITERAL));

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode parent, Captures captures, Rule.Context context) {
        Object assignments;
        PlanNode subquery = context.getLookup().resolve(parent.getSubquery());
        if (subquery instanceof ProjectNode) {
            ValuesNode values;
            ProjectNode project = (ProjectNode)subquery;
            PlanNode planNode = context.getLookup().resolve(project.getSource());
            if (planNode instanceof ValuesNode && TransformCorrelatedSingleRowSubqueryToProject.isSingleRowValuesWithNoColumns(values = (ValuesNode)planNode)) {
                assignments = Assignments.builder().putIdentities(parent.getInput().getOutputSymbols()).putAll(project.getAssignments()).build();
                return Rule.Result.ofPlanNode(this.projectNode(parent.getInput(), (Assignments)assignments, context));
            }
        }
        if (subquery instanceof ValuesNode) {
            ValuesNode values = (ValuesNode)subquery;
            if (TransformCorrelatedSingleRowSubqueryToProject.isSingleRowValuesWithNoColumns(values)) {
                return Rule.Result.ofPlanNode(parent.getInput());
            }
            if (values.getRowCount() == 1 && (assignments = values.getRows().orElseThrow().get(0)) instanceof Row) {
                Row row = (Row)assignments;
                assignments = Assignments.builder().putIdentities(parent.getInput().getOutputSymbols());
                Streams.forEachPair(values.getOutputSymbols().stream(), row.getItems().stream(), ((Assignments.Builder)assignments)::put);
                return Rule.Result.ofPlanNode(this.projectNode(parent.getInput(), ((Assignments.Builder)assignments).build(), context));
            }
        }
        return Rule.Result.empty();
    }

    private ProjectNode projectNode(PlanNode source, Assignments assignments, Rule.Context context) {
        return new ProjectNode(context.getIdAllocator().getNextId(), source, assignments);
    }

    private static boolean isSingleRowValuesWithNoColumns(ValuesNode values) {
        return values.getRowCount() == 1 && values.getOutputSymbols().isEmpty();
    }
}

