/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.Cardinality;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.Expression;
import java.util.List;

public class RemoveRedundantTopN
implements Rule<TopNNode> {
    private static final Pattern<TopNNode> PATTERN = Patterns.topN();

    @Override
    public Pattern<TopNNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TopNNode node, Captures captures, Rule.Context context) {
        if (node.getCount() == 0L) {
            return Rule.Result.ofPlanNode(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        Cardinality sourceCardinality = QueryCardinalityUtil.extractCardinality(node.getSource(), context.getLookup());
        if (sourceCardinality.isScalar()) {
            return Rule.Result.ofPlanNode(node.getSource());
        }
        if (sourceCardinality.isAtMost(node.getCount())) {
            return Rule.Result.ofPlanNode(new SortNode(context.getIdAllocator().getNextId(), node.getSource(), node.getOrderingScheme(), false));
        }
        return Rule.Result.empty();
    }
}

