/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.Cardinality;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Expression;

public class RemoveRedundantExists
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode().matching(node -> node.getSubqueryAssignments().getExpressions().stream().allMatch(expression -> expression instanceof ExistsPredicate && ((ExistsPredicate)expression).getSubquery().equals((Object)BooleanLiteral.TRUE_LITERAL)));

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode node, Captures captures, Rule.Context context) {
        BooleanLiteral result;
        Assignments.Builder assignments = Assignments.builder();
        assignments.putIdentities(node.getInput().getOutputSymbols());
        Cardinality subqueryCardinality = QueryCardinalityUtil.extractCardinality(node.getSubquery(), context.getLookup());
        if (subqueryCardinality.isEmpty()) {
            result = BooleanLiteral.FALSE_LITERAL;
        } else if (subqueryCardinality.isAtLeastScalar()) {
            result = BooleanLiteral.TRUE_LITERAL;
        } else {
            return Rule.Result.empty();
        }
        for (Symbol output : node.getSubqueryAssignments().getOutputs()) {
            assignments.put(output, (Expression)result);
        }
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), node.getInput(), assignments.build()));
    }
}

