/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PruneTableFunctionProcessorSourceColumns
implements Rule<TableFunctionProcessorNode> {
    private static final Pattern<TableFunctionProcessorNode> PATTERN = Patterns.tableFunctionProcessor();

    @Override
    public Pattern<TableFunctionProcessorNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableFunctionProcessorNode node, Captures captures, Rule.Context context) {
        if (node.getSource().isEmpty()) {
            return Rule.Result.empty();
        }
        ImmutableSet.Builder requiredInputs = ImmutableSet.builder();
        node.getPassThroughSpecifications().stream().map(TableFunctionNode.PassThroughSpecification::columns).flatMap(Collection::stream).map(TableFunctionNode.PassThroughColumn::symbol).forEach(arg_0 -> ((ImmutableSet.Builder)requiredInputs).add(arg_0));
        node.getRequiredSymbols().stream().forEach(arg_0 -> ((ImmutableSet.Builder)requiredInputs).addAll(arg_0));
        node.getSpecification().ifPresent(specification -> {
            requiredInputs.addAll(specification.getPartitionBy());
            specification.getOrderingScheme().ifPresent(orderingScheme -> requiredInputs.addAll(orderingScheme.getOrderBy()));
        });
        node.getHashSymbol().ifPresent(arg_0 -> ((ImmutableSet.Builder)requiredInputs).add(arg_0));
        Optional<Map> updatedMarkerSymbols = node.getMarkerSymbols().map(mapping -> Maps.filterKeys((Map)mapping, arg_0 -> ((ImmutableSet)requiredInputs.build()).contains(arg_0)));
        updatedMarkerSymbols.ifPresent(mapping -> requiredInputs.addAll(mapping.values()));
        return Util.restrictOutputs(context.getIdAllocator(), node.getSource().orElseThrow(), (Set<Symbol>)requiredInputs.build()).map(child -> Rule.Result.ofPlanNode(new TableFunctionProcessorNode(node.getId(), node.getName(), node.getProperOutputs(), Optional.of(child), node.isPruneWhenEmpty(), node.getPassThroughSpecifications(), node.getRequiredSymbols(), updatedMarkerSymbols, node.getSpecification(), node.getPrePartitioned(), node.getPreSorted(), node.getHashSymbol(), node.getHandle()))).orElse(Rule.Result.empty());
    }
}

