/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PruneTableFunctionProcessorColumns
extends ProjectOffPushDownRule<TableFunctionProcessorNode> {
    public PruneTableFunctionProcessorColumns() {
        super(Patterns.tableFunctionProcessor());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, TableFunctionProcessorNode node, Set<Symbol> referencedOutputs) {
        int prunedPassThroughCount;
        List prunedPassThroughSpecifications = (List)node.getPassThroughSpecifications().stream().map(sourceSpecification -> {
            List prunedPassThroughColumns = (List)sourceSpecification.columns().stream().filter(column -> referencedOutputs.contains(column.symbol())).collect(ImmutableList.toImmutableList());
            return new TableFunctionNode.PassThroughSpecification(sourceSpecification.declaredAsPassThrough(), prunedPassThroughColumns);
        }).collect(ImmutableList.toImmutableList());
        int originalPassThroughCount = node.getPassThroughSpecifications().stream().map(TableFunctionNode.PassThroughSpecification::columns).mapToInt(List::size).sum();
        if (originalPassThroughCount == (prunedPassThroughCount = prunedPassThroughSpecifications.stream().map(TableFunctionNode.PassThroughSpecification::columns).mapToInt(List::size).sum())) {
            return Optional.empty();
        }
        return Optional.of(new TableFunctionProcessorNode(node.getId(), node.getName(), node.getProperOutputs(), node.getSource(), node.isPruneWhenEmpty(), prunedPassThroughSpecifications, node.getRequiredSymbols(), node.getMarkerSymbols(), node.getSpecification(), node.getPrePartitioned(), node.getPreSorted(), node.getHashSymbol(), node.getHandle()));
    }
}

