/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ChildReplacer;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.UnionNode;
import java.util.List;

public class PruneDistinctAggregation
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(PruneDistinctAggregation::isDistinctOperator);

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        Lookup lookup = context.getLookup();
        DistinctAggregationRewriter rewriter = new DistinctAggregationRewriter(lookup);
        List newSources = (List)node.getSources().stream().map(lookup::resolve).map(source -> source.accept(rewriter, true)).collect(ImmutableList.toImmutableList());
        if (rewriter.isRewritten()) {
            return Rule.Result.ofPlanNode(ChildReplacer.replaceChildren(node, newSources));
        }
        return Rule.Result.empty();
    }

    private static boolean isDistinctOperator(AggregationNode node) {
        return node.getAggregations().isEmpty();
    }

    private static class DistinctAggregationRewriter
    extends PlanVisitor<PlanNode, Boolean> {
        private final Lookup lookup;
        private boolean rewritten;

        public DistinctAggregationRewriter(Lookup lookup) {
            this.lookup = lookup;
            this.rewritten = false;
        }

        public boolean isRewritten() {
            return this.rewritten;
        }

        private PlanNode rewriteChildren(PlanNode node, Boolean context) {
            List newSources = (List)node.getSources().stream().map(this.lookup::resolve).map(source -> source.accept(this, context)).collect(ImmutableList.toImmutableList());
            return ChildReplacer.replaceChildren(node, newSources);
        }

        @Override
        protected PlanNode visitPlan(PlanNode node, Boolean context) {
            return this.rewriteChildren(node, false);
        }

        @Override
        public PlanNode visitUnion(UnionNode node, Boolean context) {
            return this.rewriteChildren(node, context);
        }

        @Override
        public PlanNode visitIntersect(IntersectNode node, Boolean context) {
            if (node.isDistinct()) {
                return this.rewriteChildren(node, context);
            }
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public PlanNode visitExcept(ExceptNode node, Boolean context) {
            if (node.isDistinct()) {
                return this.rewriteChildren(node, context);
            }
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, Boolean context) {
            boolean distinct = PruneDistinctAggregation.isDistinctOperator(node);
            PlanNode rewrittenNode = this.lookup.resolve(node.getSource()).accept(this, distinct);
            if (context.booleanValue() && distinct) {
                this.rewritten = true;
                return rewrittenNode;
            }
            return AggregationNode.builderFrom(node).setSource(rewrittenNode).setPreGroupedSymbols((List<Symbol>)ImmutableList.of()).build();
        }
    }
}

