/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.WindowFrame;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class ImplementTableFunctionSource
implements Rule<TableFunctionNode> {
    private static final Pattern<TableFunctionNode> PATTERN = Patterns.tableFunction();
    private static final WindowNode.Frame FULL_FRAME = new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private static final DataOrganizationSpecification UNORDERED_SINGLE_PARTITION = new DataOrganizationSpecification((List<Symbol>)ImmutableList.of(), Optional.empty());
    private final Metadata metadata;

    public ImplementTableFunctionSource(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<TableFunctionNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableFunctionNode node, Captures captures, Rule.Context context) {
        NodeWithSymbols finalResultSource;
        if (node.getSources().isEmpty()) {
            return Rule.Result.ofPlanNode(new TableFunctionProcessorNode(node.getId(), node.getName(), node.getProperOutputs(), Optional.empty(), false, (List<TableFunctionNode.PassThroughSpecification>)ImmutableList.of(), (List<List<Symbol>>)ImmutableList.of(), Optional.empty(), Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0, Optional.empty(), node.getHandle()));
        }
        if (node.getSources().size() == 1) {
            TableFunctionNode.TableArgumentProperties sourceProperties = (TableFunctionNode.TableArgumentProperties)Iterables.getOnlyElement(node.getTableArgumentProperties());
            return Rule.Result.ofPlanNode(new TableFunctionProcessorNode(node.getId(), node.getName(), node.getProperOutputs(), Optional.of((PlanNode)Iterables.getOnlyElement(node.getSources())), sourceProperties.isPruneWhenEmpty(), (List<TableFunctionNode.PassThroughSpecification>)ImmutableList.of((Object)sourceProperties.getPassThroughSpecification()), (List<List<Symbol>>)ImmutableList.of(sourceProperties.getRequiredColumns()), Optional.empty(), sourceProperties.getSpecification(), (Set<Symbol>)ImmutableSet.of(), 0, Optional.empty(), node.getHandle()));
        }
        Map<String, SourceWithProperties> sources = ImplementTableFunctionSource.mapSourcesByName(node.getSources(), node.getTableArgumentProperties());
        ImmutableList.Builder intermediateResultsBuilder = ImmutableList.builder();
        ResolvedFunction rowNumberFunction = this.metadata.resolveFunction(context.getSession(), QualifiedName.of((String)"row_number"), (List<TypeSignatureProvider>)ImmutableList.of());
        ResolvedFunction countFunction = this.metadata.resolveFunction(context.getSession(), QualifiedName.of((String)"count"), (List<TypeSignatureProvider>)ImmutableList.of());
        for (List<String> copartitioningList : node.getCopartitioningLists()) {
            List sourceList = (List)copartitioningList.stream().map(sources::get).collect(ImmutableList.toImmutableList());
            intermediateResultsBuilder.add((Object)ImplementTableFunctionSource.copartition(sourceList, rowNumberFunction, countFunction, context));
        }
        Set copartitionedSources = (Set)node.getCopartitioningLists().stream().flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        sources.entrySet().stream().filter(entry -> !copartitionedSources.contains(entry.getKey())).map(entry -> ImplementTableFunctionSource.planWindowFunctionsForSource(((SourceWithProperties)entry.getValue()).source(), ((SourceWithProperties)entry.getValue()).properties(), rowNumberFunction, countFunction, context)).forEach(arg_0 -> ((ImmutableList.Builder)intermediateResultsBuilder).add(arg_0));
        ImmutableList intermediateResultSources = intermediateResultsBuilder.build();
        if (intermediateResultSources.size() == 1) {
            finalResultSource = (NodeWithSymbols)Iterables.getOnlyElement((Iterable)intermediateResultSources);
        } else {
            NodeWithSymbols first = (NodeWithSymbols)intermediateResultSources.get(0);
            NodeWithSymbols second = (NodeWithSymbols)intermediateResultSources.get(1);
            JoinedNodes joined = ImplementTableFunctionSource.join(first, second, context);
            for (int i = 2; i < intermediateResultSources.size(); ++i) {
                NodeWithSymbols joinedWithSymbols = ImplementTableFunctionSource.appendHelperSymbolsForJoinedNodes(joined, context);
                joined = ImplementTableFunctionSource.join(joinedWithSymbols, (NodeWithSymbols)intermediateResultSources.get(i), context);
            }
            finalResultSource = ImplementTableFunctionSource.appendHelperSymbolsForJoinedNodes(joined, context);
        }
        Map<Symbol, Symbol> rowNumberSymbols = finalResultSource.rowNumberSymbolsMapping();
        Symbol finalRowNumberSymbol = finalResultSource.rowNumber();
        List<Symbol> finalPartitionBy = finalResultSource.partitionBy();
        NodeWithMarkers marked = ImplementTableFunctionSource.appendMarkerSymbols(finalResultSource.node(), (Set<Symbol>)ImmutableSet.copyOf(rowNumberSymbols.values()), finalRowNumberSymbol, context);
        ImmutableMap markerSymbols = (ImmutableMap)rowNumberSymbols.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> marked.symbolToMarker().get(entry.getValue())));
        Optional<OrderingScheme> finalOrderBy = Optional.of(new OrderingScheme((List<Symbol>)ImmutableList.of((Object)finalRowNumberSymbol), (Map<Symbol, SortOrder>)ImmutableMap.of((Object)finalRowNumberSymbol, (Object)SortOrder.ASC_NULLS_LAST)));
        boolean pruneWhenEmpty = node.getTableArgumentProperties().stream().anyMatch(TableFunctionNode.TableArgumentProperties::isPruneWhenEmpty);
        List passThroughSpecifications = (List)node.getTableArgumentProperties().stream().map(TableFunctionNode.TableArgumentProperties::getPassThroughSpecification).collect(ImmutableList.toImmutableList());
        List requiredSymbols = (List)node.getTableArgumentProperties().stream().map(TableFunctionNode.TableArgumentProperties::getRequiredColumns).collect(ImmutableList.toImmutableList());
        return Rule.Result.ofPlanNode(new TableFunctionProcessorNode(node.getId(), node.getName(), node.getProperOutputs(), Optional.of(marked.node()), pruneWhenEmpty, passThroughSpecifications, requiredSymbols, Optional.of(markerSymbols), Optional.of(new DataOrganizationSpecification(finalPartitionBy, finalOrderBy)), (Set<Symbol>)ImmutableSet.of(), 0, Optional.empty(), node.getHandle()));
    }

    private static Map<String, SourceWithProperties> mapSourcesByName(List<PlanNode> sources, List<TableFunctionNode.TableArgumentProperties> properties) {
        return (Map)Streams.zip(sources.stream(), properties.stream(), SourceWithProperties::new).collect(ImmutableMap.toImmutableMap(entry -> entry.properties().getArgumentName(), Function.identity()));
    }

    private static NodeWithSymbols planWindowFunctionsForSource(PlanNode source, TableFunctionNode.TableArgumentProperties argumentProperties, ResolvedFunction rowNumberFunction, ResolvedFunction countFunction, Rule.Context context) {
        String argumentName = argumentProperties.getArgumentName();
        Symbol rowNumber = context.getSymbolAllocator().newSymbol(argumentName + "_row_number", (Type)BigintType.BIGINT);
        Map rowNumberSymbolMapping = (Map)source.getOutputSymbols().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), symbol -> rowNumber));
        Symbol partitionSize = context.getSymbolAllocator().newSymbol(argumentName + "_partition_size", (Type)BigintType.BIGINT);
        DataOrganizationSpecification specification = argumentProperties.getSpecification().orElse(UNORDERED_SINGLE_PARTITION);
        WindowNode window = new WindowNode(context.getIdAllocator().getNextId(), source, specification, (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumber, (Object)new WindowNode.Function(rowNumberFunction, (List<Expression>)ImmutableList.of(), FULL_FRAME, false), (Object)partitionSize, (Object)new WindowNode.Function(countFunction, (List<Expression>)ImmutableList.of(), FULL_FRAME, false)), Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0);
        return new NodeWithSymbols(window, rowNumber, partitionSize, specification.getPartitionBy(), argumentProperties.isPruneWhenEmpty(), rowNumberSymbolMapping);
    }

    private static NodeWithSymbols copartition(List<SourceWithProperties> sourceList, ResolvedFunction rowNumberFunction, ResolvedFunction countFunction, Rule.Context context) {
        Preconditions.checkArgument((sourceList.size() >= 2 ? 1 : 0) != 0, (Object)"co-partitioning list should contain at least two tables");
        sourceList = (List)sourceList.stream().sorted(Comparator.comparingInt(source -> source.properties().isPruneWhenEmpty() ? -1 : 1)).collect(ImmutableList.toImmutableList());
        NodeWithSymbols first = ImplementTableFunctionSource.planWindowFunctionsForSource(((SourceWithProperties)sourceList.get(0)).source(), ((SourceWithProperties)sourceList.get(0)).properties(), rowNumberFunction, countFunction, context);
        NodeWithSymbols second = ImplementTableFunctionSource.planWindowFunctionsForSource(((SourceWithProperties)sourceList.get(1)).source(), ((SourceWithProperties)sourceList.get(1)).properties(), rowNumberFunction, countFunction, context);
        JoinedNodes copartitioned = ImplementTableFunctionSource.copartition(first, second, context);
        for (int i = 2; i < sourceList.size(); ++i) {
            NodeWithSymbols copartitionedWithSymbols = ImplementTableFunctionSource.appendHelperSymbolsForCopartitionedNodes(copartitioned, context);
            NodeWithSymbols next = ImplementTableFunctionSource.planWindowFunctionsForSource(((SourceWithProperties)sourceList.get(i)).source(), ((SourceWithProperties)sourceList.get(i)).properties(), rowNumberFunction, countFunction, context);
            copartitioned = ImplementTableFunctionSource.copartition(copartitionedWithSymbols, next, context);
        }
        return ImplementTableFunctionSource.appendHelperSymbolsForCopartitionedNodes(copartitioned, context);
    }

    private static JoinedNodes copartition(NodeWithSymbols left, NodeWithSymbols right, Rule.Context context) {
        Preconditions.checkArgument((left.partitionBy().size() == right.partitionBy().size() ? 1 : 0) != 0, (Object)"co-partitioning lists do not match");
        Preconditions.checkState((!left.partitionBy().isEmpty() ? 1 : 0) != 0, (Object)"co-partitioned tables must have partitioning columns");
        SymbolReference leftRowNumber = left.rowNumber().toSymbolReference();
        SymbolReference leftPartitionSize = left.partitionSize().toSymbolReference();
        List leftPartitionBy = (List)left.partitionBy().stream().map(Symbol::toSymbolReference).collect(ImmutableList.toImmutableList());
        SymbolReference rightRowNumber = right.rowNumber().toSymbolReference();
        SymbolReference rightPartitionSize = right.partitionSize().toSymbolReference();
        List rightPartitionBy = (List)right.partitionBy().stream().map(Symbol::toSymbolReference).collect(ImmutableList.toImmutableList());
        List copartitionConjuncts = (List)Streams.zip(leftPartitionBy.stream(), rightPartitionBy.stream(), (leftColumn, rightColumn) -> new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, leftColumn, rightColumn))).collect(ImmutableList.toImmutableList());
        LogicalExpression joinCondition = new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.builder().addAll((Iterable)copartitionConjuncts).add((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)leftRowNumber, (Expression)rightRowNumber), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)leftRowNumber, (Expression)rightPartitionSize), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)rightRowNumber, (Expression)new GenericLiteral("BIGINT", "1")))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)rightRowNumber, (Expression)leftPartitionSize), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)leftRowNumber, (Expression)new GenericLiteral("BIGINT", "1"))))))).build());
        JoinNode.Type joinType = left.pruneWhenEmpty() && right.pruneWhenEmpty() ? JoinNode.Type.INNER : (left.pruneWhenEmpty() ? JoinNode.Type.LEFT : (right.pruneWhenEmpty() ? JoinNode.Type.RIGHT : JoinNode.Type.FULL));
        return new JoinedNodes(new JoinNode(context.getIdAllocator().getNextId(), joinType, left.node(), right.node(), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), left.node().getOutputSymbols(), right.node().getOutputSymbols(), false, Optional.of(joinCondition), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), Optional.empty()), left.rowNumber(), left.partitionSize(), left.partitionBy(), left.pruneWhenEmpty(), left.rowNumberSymbolsMapping(), right.rowNumber(), right.partitionSize(), right.partitionBy(), right.pruneWhenEmpty(), right.rowNumberSymbolsMapping());
    }

    private static NodeWithSymbols appendHelperSymbolsForCopartitionedNodes(JoinedNodes copartitionedNodes, Rule.Context context) {
        Preconditions.checkArgument((copartitionedNodes.leftPartitionBy().size() == copartitionedNodes.rightPartitionBy().size() ? 1 : 0) != 0, (Object)"co-partitioning lists do not match");
        SymbolReference leftRowNumber = copartitionedNodes.leftRowNumber().toSymbolReference();
        SymbolReference leftPartitionSize = copartitionedNodes.leftPartitionSize().toSymbolReference();
        SymbolReference rightRowNumber = copartitionedNodes.rightRowNumber().toSymbolReference();
        SymbolReference rightPartitionSize = copartitionedNodes.rightPartitionSize().toSymbolReference();
        Symbol joinedRowNumber = context.getSymbolAllocator().newSymbol("combined_row_number", (Type)BigintType.BIGINT);
        IfExpression rowNumberExpression = new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new CoalesceExpression((Expression)leftRowNumber, (Expression)new GenericLiteral("BIGINT", "-1"), new Expression[0]), (Expression)new CoalesceExpression((Expression)rightRowNumber, (Expression)new GenericLiteral("BIGINT", "-1"), new Expression[0])), (Expression)leftRowNumber, (Expression)rightRowNumber);
        Symbol joinedPartitionSize = context.getSymbolAllocator().newSymbol("combined_partition_size", (Type)BigintType.BIGINT);
        IfExpression partitionSizeExpression = new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new CoalesceExpression((Expression)leftPartitionSize, (Expression)new GenericLiteral("BIGINT", "-1"), new Expression[0]), (Expression)new CoalesceExpression((Expression)rightPartitionSize, (Expression)new GenericLiteral("BIGINT", "-1"), new Expression[0])), (Expression)leftPartitionSize, (Expression)rightPartitionSize);
        ImmutableList.Builder joinedPartitionBy = ImmutableList.builder();
        Assignments.Builder joinedPartitionByAssignments = Assignments.builder();
        for (int i = 0; i < copartitionedNodes.leftPartitionBy().size(); ++i) {
            Symbol leftColumn = copartitionedNodes.leftPartitionBy().get(i);
            Symbol rightColumn = copartitionedNodes.rightPartitionBy().get(i);
            Type type = context.getSymbolAllocator().getTypes().get(leftColumn);
            Symbol joinedColumn = context.getSymbolAllocator().newSymbol("combined_partition_column", type);
            joinedPartitionByAssignments.put(joinedColumn, (Expression)new CoalesceExpression((Expression)leftColumn.toSymbolReference(), (Expression)rightColumn.toSymbolReference(), new Expression[0]));
            joinedPartitionBy.add((Object)joinedColumn);
        }
        ProjectNode project = new ProjectNode(context.getIdAllocator().getNextId(), copartitionedNodes.joinedNode(), Assignments.builder().putIdentities(copartitionedNodes.joinedNode().getOutputSymbols()).put(joinedRowNumber, (Expression)rowNumberExpression).put(joinedPartitionSize, (Expression)partitionSizeExpression).putAll(joinedPartitionByAssignments.build()).build());
        boolean joinedPruneWhenEmpty = copartitionedNodes.leftPruneWhenEmpty() || copartitionedNodes.rightPruneWhenEmpty();
        ImmutableMap joinedRowNumberSymbolsMapping = ImmutableMap.builder().putAll(copartitionedNodes.leftRowNumberSymbolsMapping()).putAll(copartitionedNodes.rightRowNumberSymbolsMapping()).buildOrThrow();
        return new NodeWithSymbols(project, joinedRowNumber, joinedPartitionSize, (List<Symbol>)joinedPartitionBy.build(), joinedPruneWhenEmpty, (Map<Symbol, Symbol>)joinedRowNumberSymbolsMapping);
    }

    private static JoinedNodes join(NodeWithSymbols left, NodeWithSymbols right, Rule.Context context) {
        SymbolReference leftRowNumber = left.rowNumber().toSymbolReference();
        SymbolReference leftPartitionSize = left.partitionSize().toSymbolReference();
        SymbolReference rightRowNumber = right.rowNumber().toSymbolReference();
        SymbolReference rightPartitionSize = right.partitionSize().toSymbolReference();
        LogicalExpression joinCondition = new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)leftRowNumber, (Expression)rightRowNumber), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)leftRowNumber, (Expression)rightPartitionSize), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)rightRowNumber, (Expression)new GenericLiteral("BIGINT", "1")))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)rightRowNumber, (Expression)leftPartitionSize), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)leftRowNumber, (Expression)new GenericLiteral("BIGINT", "1"))))));
        JoinNode.Type joinType = left.pruneWhenEmpty() && right.pruneWhenEmpty() ? JoinNode.Type.INNER : (left.pruneWhenEmpty() ? JoinNode.Type.LEFT : (right.pruneWhenEmpty() ? JoinNode.Type.RIGHT : JoinNode.Type.FULL));
        return new JoinedNodes(new JoinNode(context.getIdAllocator().getNextId(), joinType, left.node(), right.node(), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), left.node().getOutputSymbols(), right.node().getOutputSymbols(), false, Optional.of(joinCondition), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), Optional.empty()), left.rowNumber(), left.partitionSize(), left.partitionBy(), left.pruneWhenEmpty(), left.rowNumberSymbolsMapping(), right.rowNumber(), right.partitionSize(), right.partitionBy(), right.pruneWhenEmpty(), right.rowNumberSymbolsMapping());
    }

    private static NodeWithSymbols appendHelperSymbolsForJoinedNodes(JoinedNodes joinedNodes, Rule.Context context) {
        SymbolReference leftRowNumber = joinedNodes.leftRowNumber().toSymbolReference();
        SymbolReference leftPartitionSize = joinedNodes.leftPartitionSize().toSymbolReference();
        SymbolReference rightRowNumber = joinedNodes.rightRowNumber().toSymbolReference();
        SymbolReference rightPartitionSize = joinedNodes.rightPartitionSize().toSymbolReference();
        Symbol joinedRowNumber = context.getSymbolAllocator().newSymbol("combined_row_number", (Type)BigintType.BIGINT);
        IfExpression rowNumberExpression = new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new CoalesceExpression((Expression)leftRowNumber, (Expression)new GenericLiteral("BIGINT", "-1"), new Expression[0]), (Expression)new CoalesceExpression((Expression)rightRowNumber, (Expression)new GenericLiteral("BIGINT", "-1"), new Expression[0])), (Expression)leftRowNumber, (Expression)rightRowNumber);
        Symbol joinedPartitionSize = context.getSymbolAllocator().newSymbol("combined_partition_size", (Type)BigintType.BIGINT);
        IfExpression partitionSizeExpression = new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new CoalesceExpression((Expression)leftPartitionSize, (Expression)new GenericLiteral("BIGINT", "-1"), new Expression[0]), (Expression)new CoalesceExpression((Expression)rightPartitionSize, (Expression)new GenericLiteral("BIGINT", "-1"), new Expression[0])), (Expression)leftPartitionSize, (Expression)rightPartitionSize);
        ProjectNode project = new ProjectNode(context.getIdAllocator().getNextId(), joinedNodes.joinedNode(), Assignments.builder().putIdentities(joinedNodes.joinedNode().getOutputSymbols()).put(joinedRowNumber, (Expression)rowNumberExpression).put(joinedPartitionSize, (Expression)partitionSizeExpression).build());
        ImmutableList joinedPartitionBy = ImmutableList.builder().addAll(joinedNodes.leftPartitionBy()).addAll(joinedNodes.rightPartitionBy()).build();
        boolean joinedPruneWhenEmpty = joinedNodes.leftPruneWhenEmpty() || joinedNodes.rightPruneWhenEmpty();
        ImmutableMap joinedRowNumberSymbolsMapping = ImmutableMap.builder().putAll(joinedNodes.leftRowNumberSymbolsMapping()).putAll(joinedNodes.rightRowNumberSymbolsMapping()).buildOrThrow();
        return new NodeWithSymbols(project, joinedRowNumber, joinedPartitionSize, (List<Symbol>)joinedPartitionBy, joinedPruneWhenEmpty, (Map<Symbol, Symbol>)joinedRowNumberSymbolsMapping);
    }

    private static NodeWithMarkers appendMarkerSymbols(PlanNode node, Set<Symbol> symbols, Symbol referenceSymbol, Rule.Context context) {
        Assignments.Builder assignments = Assignments.builder();
        assignments.putIdentities(node.getOutputSymbols());
        ImmutableMap.Builder symbolsToMarkers = ImmutableMap.builder();
        for (Symbol symbol : symbols) {
            Symbol marker = context.getSymbolAllocator().newSymbol("marker", (Type)BigintType.BIGINT);
            symbolsToMarkers.put((Object)symbol, (Object)marker);
            SymbolReference actual = symbol.toSymbolReference();
            SymbolReference reference = referenceSymbol.toSymbolReference();
            assignments.put(marker, (Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)actual, (Expression)reference), (Expression)actual, (Expression)new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT))));
        }
        ProjectNode project = new ProjectNode(context.getIdAllocator().getNextId(), node, assignments.build());
        return new NodeWithMarkers(project, (Map<Symbol, Symbol>)symbolsToMarkers.buildOrThrow());
    }

    private record NodeWithSymbols(PlanNode node, Symbol rowNumber, Symbol partitionSize, List<Symbol> partitionBy, boolean pruneWhenEmpty, Map<Symbol, Symbol> rowNumberSymbolsMapping) {
        NodeWithSymbols {
            Objects.requireNonNull(node, "node is null");
            Objects.requireNonNull(rowNumber, "rowNumber is null");
            Objects.requireNonNull(partitionSize, "partitionSize is null");
            partitionBy = ImmutableList.copyOf(partitionBy);
            rowNumberSymbolsMapping = ImmutableMap.copyOf(rowNumberSymbolsMapping);
        }
    }

    private record JoinedNodes(PlanNode joinedNode, Symbol leftRowNumber, Symbol leftPartitionSize, List<Symbol> leftPartitionBy, boolean leftPruneWhenEmpty, Map<Symbol, Symbol> leftRowNumberSymbolsMapping, Symbol rightRowNumber, Symbol rightPartitionSize, List<Symbol> rightPartitionBy, boolean rightPruneWhenEmpty, Map<Symbol, Symbol> rightRowNumberSymbolsMapping) {
        JoinedNodes {
            Objects.requireNonNull(joinedNode, "joinedNode is null");
            Objects.requireNonNull(leftRowNumber, "leftRowNumber is null");
            Objects.requireNonNull(leftPartitionSize, "leftPartitionSize is null");
            leftPartitionBy = ImmutableList.copyOf(leftPartitionBy);
            leftRowNumberSymbolsMapping = ImmutableMap.copyOf(leftRowNumberSymbolsMapping);
            Objects.requireNonNull(rightRowNumber, "rightRowNumber is null");
            Objects.requireNonNull(rightPartitionSize, "rightPartitionSize is null");
            rightPartitionBy = ImmutableList.copyOf(rightPartitionBy);
            rightRowNumberSymbolsMapping = ImmutableMap.copyOf(rightRowNumberSymbolsMapping);
        }
    }

    private record NodeWithMarkers(PlanNode node, Map<Symbol, Symbol> symbolToMarker) {
        NodeWithMarkers {
            Objects.requireNonNull(node, "node is null");
            symbolToMarker = ImmutableMap.copyOf(symbolToMarker);
        }
    }

    private record SourceWithProperties(PlanNode source, TableFunctionNode.TableArgumentProperties properties) {
        SourceWithProperties {
            Objects.requireNonNull(source, "source is null");
            Objects.requireNonNull(properties, "properties is null");
        }
    }
}

