/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.FunctionCallBuilder;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Set;

public class ArraySortAfterArrayDistinct
extends ExpressionRewriteRuleSet {
    public ArraySortAfterArrayDistinct(PlannerContext plannerContext) {
        super((Expression expression, Rule.Context context) -> ArraySortAfterArrayDistinct.rewrite(expression, context, plannerContext.getMetadata()));
    }

    @Override
    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.projectExpressionRewrite(), this.filterExpressionRewrite(), this.joinExpressionRewrite(), this.valuesExpressionRewrite(), this.patternRecognitionExpressionRewrite());
    }

    private static Expression rewrite(Expression expression, Rule.Context context, Metadata metadata) {
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Session session = context.getSession();
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(metadata, session), (Expression)expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Metadata metadata;
        private final Session session;

        public Visitor(Metadata metadata, Session session) {
            this.metadata = metadata;
            this.session = session;
        }

        public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression expression;
            FunctionCall functionCall;
            ResolvedFunction resolvedFunction;
            FunctionCall rewritten = (FunctionCall)treeRewriter.defaultRewrite((Expression)node, (Object)context);
            if (this.metadata.decodeFunction(rewritten.getName()).getSignature().getName().equals("array_distinct") && Iterables.getOnlyElement((Iterable)rewritten.getArguments()) instanceof FunctionCall && (resolvedFunction = this.metadata.decodeFunction((functionCall = (FunctionCall)(expression = (Expression)Iterables.getOnlyElement((Iterable)rewritten.getArguments()))).getName())).getSignature().getName().equals("array_sort")) {
                List arraySortArguments = functionCall.getArguments();
                List arraySortArgumentsTypes = resolvedFunction.getSignature().getArgumentTypes();
                FunctionCall arrayDistinctCall = FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"array_distinct")).setArguments((List<Type>)ImmutableList.of((Object)((Type)arraySortArgumentsTypes.get(0))), (List<Expression>)ImmutableList.of((Object)((Expression)arraySortArguments.get(0)))).build();
                FunctionCallBuilder arraySortCallBuilder = FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"array_sort")).addArgument((Type)arraySortArgumentsTypes.get(0), (Expression)arrayDistinctCall);
                if (arraySortArguments.size() == 2) {
                    arraySortCallBuilder.addArgument((Type)arraySortArgumentsTypes.get(1), (Expression)arraySortArguments.get(1));
                }
                return arraySortCallBuilder.build();
            }
            return rewritten;
        }
    }
}

