/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.RowBlock;
import io.trino.spi.type.Type;
import io.trino.sql.gen.BytecodeGenerator;
import io.trino.sql.gen.BytecodeGeneratorContext;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.SqlTypeBytecodeExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RowConstructorCodeGenerator
implements BytecodeGenerator {
    private final Type rowType;
    private final List<RowExpression> arguments;

    public RowConstructorCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        this.rowType = specialForm.getType();
        this.arguments = specialForm.getArguments();
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext context) {
        BytecodeBlock block = new BytecodeBlock().setDescription("Constructor for " + this.rowType);
        CallSiteBinder binder = context.getCallSiteBinder();
        Scope scope = context.getScope();
        List types = this.rowType.getTypeParameters();
        Variable fieldBlocks = scope.createTempVariable(Block[].class);
        block.append((BytecodeNode)fieldBlocks.set(BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Block[].class), (int)this.arguments.size())));
        Variable blockBuilder = scope.createTempVariable(BlockBuilder.class);
        for (int i = 0; i < this.arguments.size(); ++i) {
            Type fieldType = (Type)types.get(i);
            Variable field = scope.createTempVariable(fieldType.getJavaType());
            block.append((BytecodeNode)blockBuilder.set(SqlTypeBytecodeExpression.constantType(binder, fieldType).invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantNull(BlockBuilderStatus.class), BytecodeExpressions.constantInt((int)1)})));
            block.comment("Clean wasNull and Generate + " + i + "-th field of row");
            block.append((BytecodeNode)context.wasNull().set(BytecodeExpressions.constantFalse()));
            block.append(context.generate(this.arguments.get(i)));
            block.putVariable(field);
            block.append((BytecodeNode)new IfStatement().condition((BytecodeNode)context.wasNull()).ifTrue((BytecodeNode)blockBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, fieldType).writeValue((BytecodeExpression)blockBuilder, (BytecodeExpression)field).pop()));
            block.append((BytecodeNode)fieldBlocks.setElement(i, blockBuilder.invoke("build", Block.class, new BytecodeExpression[0])));
        }
        BytecodeExpression rowBlock = BytecodeExpressions.invokeStatic(RowBlock.class, (String)"fromFieldBlocks", Block.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantInt((int)1), BytecodeExpressions.invokeStatic(Optional.class, (String)"empty", Optional.class, (BytecodeExpression[])new BytecodeExpression[0]), fieldBlocks});
        block.append((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, this.rowType).invoke("getObject", Object.class, new BytecodeExpression[]{rowBlock, BytecodeExpressions.constantInt((int)0)}).cast(Block.class));
        block.append((BytecodeNode)context.wasNull().set(BytecodeExpressions.constantFalse()));
        return block;
    }
}

