/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.inject.Inject;
import io.trino.client.NodeVersion;
import io.trino.cost.CostCalculator;
import io.trino.cost.StatsCalculator;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.planner.PlanFragmenter;
import io.trino.sql.planner.PlanOptimizersFactory;
import java.util.Objects;

public class QueryExplainerFactory {
    private final PlanOptimizersFactory planOptimizersFactory;
    private final PlanFragmenter planFragmenter;
    private final PlannerContext plannerContext;
    private final StatementAnalyzerFactory statementAnalyzerFactory;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final NodeVersion version;

    @Inject
    public QueryExplainerFactory(PlanOptimizersFactory planOptimizersFactory, PlanFragmenter planFragmenter, PlannerContext plannerContext, StatementAnalyzerFactory statementAnalyzerFactory, StatsCalculator statsCalculator, CostCalculator costCalculator, NodeVersion version) {
        this.planOptimizersFactory = Objects.requireNonNull(planOptimizersFactory, "planOptimizersFactory is null");
        this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "metadata is null");
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.version = Objects.requireNonNull(version, "version is null");
    }

    public QueryExplainer createQueryExplainer(AnalyzerFactory analyzerFactory) {
        return new QueryExplainer(this.planOptimizersFactory, this.planFragmenter, this.plannerContext, analyzerFactory, this.statementAnalyzerFactory, this.statsCalculator, this.costCalculator, this.version);
    }
}

