/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.ExpressionTreeUtils;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.AnchorPattern;
import io.trino.sql.tree.ExcludedPattern;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.PatternSearchMode;
import io.trino.sql.tree.ProcessingMode;
import io.trino.sql.tree.RangeQuantifier;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.SubsetDefinition;
import io.trino.sql.tree.VariableDefinition;
import io.trino.sql.util.AstUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class PatternRecognitionAnalyzer {
    private PatternRecognitionAnalyzer() {
    }

    public static PatternRecognitionAnalysis analyze(List<SubsetDefinition> subsets, List<VariableDefinition> variableDefinitions, List<MeasureDefinition> measures, RowPattern pattern, Optional<SkipTo> skipTo) {
        String label;
        Set primaryLabels = (Set)ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)pattern), Identifier.class).stream().map(PatternRecognitionAnalyzer::label).collect(ImmutableSet.toImmutableSet());
        List unionLabels = (List)subsets.stream().map(SubsetDefinition::getName).map(PatternRecognitionAnalyzer::label).collect(ImmutableList.toImmutableList());
        HashSet<String> unique = new HashSet<String>();
        for (SubsetDefinition subset : subsets) {
            label = PatternRecognitionAnalyzer.label(subset.getName());
            if (primaryLabels.contains(label)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LABEL, (Node)subset.getName(), "union pattern variable name: %s is a duplicate of primary pattern variable name", subset.getName());
            }
            if (!unique.add(label)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LABEL, (Node)subset.getName(), "union pattern variable name: %s is declared twice", subset.getName());
            }
            for (Identifier element : subset.getIdentifiers()) {
                if (primaryLabels.contains(PatternRecognitionAnalyzer.label(element))) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LABEL, (Node)element, "subset element: %s is not a primary pattern variable", element);
            }
        }
        unique = new HashSet();
        for (VariableDefinition definition : variableDefinitions) {
            label = PatternRecognitionAnalyzer.label(definition.getName());
            if (!primaryLabels.contains(label)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LABEL, (Node)definition.getName(), "defined variable: %s is not a primary pattern variable", definition.getName());
            }
            if (!unique.add(label)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LABEL, (Node)definition.getName(), "pattern variable with name: %s is defined twice", definition.getName());
            }
            Expression expression2 = definition.getExpression();
            ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)expression2), FunctionCall.class).stream().filter(functionCall -> functionCall.getProcessingMode().map(mode -> mode.getMode() == ProcessingMode.Mode.FINAL).orElse(false)).findFirst().ifPresent(functionCall -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCESSING_MODE, (Node)functionCall.getProcessingMode().get(), "FINAL semantics is not supported in DEFINE clause", new Object[0]);
            });
        }
        Sets.SetView undefinedLabels = Sets.difference((Set)primaryLabels, unique);
        ImmutableMap.Builder ranges = ImmutableMap.builder();
        AstUtils.preOrder((Node)pattern).filter(RangeQuantifier.class::isInstance).map(RangeQuantifier.class::cast).forEach(quantifier -> {
            Optional<Long> atLeast = quantifier.getAtLeast().map(LongLiteral::getParsedValue);
            atLeast.ifPresent(value -> {
                if (value < 0L) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)quantifier, "Pattern quantifier lower bound must be greater than or equal to 0", new Object[0]);
                }
                if (value > Integer.MAX_VALUE) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)quantifier, "Pattern quantifier lower bound must not exceed 2147483647", new Object[0]);
                }
            });
            Optional<Long> atMost = quantifier.getAtMost().map(LongLiteral::getParsedValue);
            atMost.ifPresent(value -> {
                if (value < 1L) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)quantifier, "Pattern quantifier upper bound must be greater than or equal to 1", new Object[0]);
                }
                if (value > Integer.MAX_VALUE) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, (Node)quantifier, "Pattern quantifier upper bound must not exceed 2147483647", new Object[0]);
                }
            });
            if (atLeast.isPresent() && atMost.isPresent() && atLeast.get() > atMost.get()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_RANGE, (Node)quantifier, "Pattern quantifier lower bound must not exceed upper bound", new Object[0]);
            }
            ranges.put((Object)NodeRef.of((Node)quantifier), (Object)new Analysis.Range(atLeast.map(Math::toIntExact), atMost.map(Math::toIntExact)));
        });
        ImmutableSet allLabels = ImmutableSet.builder().addAll((Iterable)primaryLabels).addAll((Iterable)unionLabels).build();
        skipTo.flatMap(SkipTo::getIdentifier).ifPresent(arg_0 -> PatternRecognitionAnalyzer.lambda$analyze$6((Set)allLabels, arg_0));
        List expressions = (List)Streams.concat((Stream[])new Stream[]{measures.stream().map(MeasureDefinition::getExpression), variableDefinitions.stream().map(VariableDefinition::getExpression)}).collect(ImmutableList.toImmutableList());
        expressions.forEach(expression -> AstUtils.preOrder((Node)expression).filter(child -> child instanceof PatternRecognitionRelation || child instanceof RowPattern).findFirst().ifPresent(nested -> {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NESTED_ROW_PATTERN_RECOGNITION, nested, "nested row pattern recognition in row pattern recognition", new Object[0]);
        }));
        return new PatternRecognitionAnalysis((Set<String>)allLabels, (Set<String>)undefinedLabels, (Map<NodeRef<RangeQuantifier>, Analysis.Range>)ranges.buildOrThrow());
    }

    public static void validateNoPatternSearchMode(Optional<PatternSearchMode> patternSearchMode) {
        patternSearchMode.ifPresent(mode -> {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)mode, "Pattern search modifier: %s is not allowed in MATCH_RECOGNIZE clause", mode.getMode());
        });
    }

    public static void validatePatternExclusions(Optional<PatternRecognitionRelation.RowsPerMatch> rowsPerMatch, RowPattern pattern) {
        if (rowsPerMatch.isPresent() && rowsPerMatch.get().isUnmatchedRows()) {
            AstUtils.preOrder((Node)pattern).filter(ExcludedPattern.class::isInstance).findFirst().ifPresent(exclusion -> {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_PATTERN, exclusion, "Pattern exclusion syntax is not allowed when ALL ROWS PER MATCH WITH UNMATCHED ROWS is specified", new Object[0]);
            });
        }
    }

    public static void validateNoPatternAnchors(RowPattern pattern) {
        AstUtils.preOrder((Node)pattern).filter(AnchorPattern.class::isInstance).findFirst().ifPresent(anchor -> {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_PATTERN, anchor, "Anchor pattern syntax is not allowed in window", new Object[0]);
        });
    }

    public static void validateNoMatchNumber(List<MeasureDefinition> measures, List<VariableDefinition> variableDefinitions, Set<NodeRef<FunctionCall>> patternRecognitionFunctions) {
        List expressions = (List)Streams.concat((Stream[])new Stream[]{measures.stream().map(MeasureDefinition::getExpression), variableDefinitions.stream().map(VariableDefinition::getExpression)}).collect(ImmutableList.toImmutableList());
        expressions.forEach(expression -> AstUtils.preOrder((Node)expression).filter(child -> patternRecognitionFunctions.contains(NodeRef.of((Node)child))).filter(child -> ((FunctionCall)child).getName().getSuffix().equalsIgnoreCase("MATCH_NUMBER")).findFirst().ifPresent(matchNumber -> {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION, matchNumber, "MATCH_NUMBER function is not supported in window", new Object[0]);
        }));
    }

    private static String label(Identifier identifier) {
        return identifier.getCanonicalValue();
    }

    private static /* synthetic */ void lambda$analyze$6(Set allLabels, Identifier identifier) {
        String label = PatternRecognitionAnalyzer.label(identifier);
        if (!allLabels.contains(label)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LABEL, (Node)identifier, "%s is not a primary or union pattern variable", identifier);
        }
    }

    public static class PatternRecognitionAnalysis {
        private final Set<String> allLabels;
        private final Set<String> undefinedLabels;
        private final Map<NodeRef<RangeQuantifier>, Analysis.Range> ranges;

        public PatternRecognitionAnalysis(Set<String> allLabels, Set<String> undefinedLabels, Map<NodeRef<RangeQuantifier>, Analysis.Range> ranges) {
            this.allLabels = Objects.requireNonNull(allLabels, "allLabels is null");
            this.undefinedLabels = ImmutableSet.copyOf((Collection)Objects.requireNonNull(undefinedLabels, "undefinedLabels is null"));
            this.ranges = ImmutableMap.copyOf(Objects.requireNonNull(ranges, "ranges is null"));
        }

        public Set<String> getAllLabels() {
            return this.allLabels;
        }

        public Set<String> getUndefinedLabels() {
            return this.undefinedLabels;
        }

        public Map<NodeRef<RangeQuantifier>, Analysis.Range> getRanges() {
            return this.ranges;
        }
    }
}

