/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.trino.execution.Column;
import io.trino.sql.analyzer.Analysis;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

@Immutable
public final class OutputColumn {
    private final Column column;
    private final Set<Analysis.SourceColumn> sourceColumns;

    @JsonCreator
    public OutputColumn(@JsonProperty(value="column") Column column, @JsonProperty(value="sourceColumns") Set<Analysis.SourceColumn> sourceColumns) {
        this.column = Objects.requireNonNull(column, "column is null");
        this.sourceColumns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(sourceColumns, "sourceColumns is null"));
    }

    @JsonProperty
    public Column getColumn() {
        return this.column;
    }

    @JsonProperty
    public Set<Analysis.SourceColumn> getSourceColumns() {
        return this.sourceColumns;
    }

    public int hashCode() {
        return Objects.hash(this.column, this.sourceColumns);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OutputColumn entry = (OutputColumn)obj;
        return Objects.equals(this.column, entry.column) && Objects.equals(this.sourceColumns, entry.sourceColumns);
    }
}

