/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.CatalogServiceProvider;
import io.trino.metadata.Split;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.predicate.TupleDomain;
import io.trino.split.PageSourceProvider;
import java.util.List;
import java.util.Objects;

public class PageSourceManager
implements PageSourceProvider {
    private final CatalogServiceProvider<ConnectorPageSourceProvider> pageSourceProvider;

    @Inject
    public PageSourceManager(CatalogServiceProvider<ConnectorPageSourceProvider> pageSourceProvider) {
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
    }

    @Override
    public ConnectorPageSource createPageSource(Session session, Split split, TableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        Objects.requireNonNull(columns, "columns is null");
        Preconditions.checkArgument((boolean)split.getCatalogHandle().equals((Object)table.getCatalogHandle()), (Object)"mismatched split and table");
        CatalogHandle catalogHandle = split.getCatalogHandle();
        ConnectorPageSourceProvider provider = this.pageSourceProvider.getService(catalogHandle);
        TupleDomain constraint = dynamicFilter.getCurrentPredicate();
        if (constraint.isNone()) {
            return new EmptyPageSource();
        }
        if (!SystemSessionProperties.isAllowPushdownIntoConnectors(session)) {
            dynamicFilter = DynamicFilter.EMPTY;
        }
        return provider.createPageSource(table.getTransaction(), session.toConnectorSession(catalogHandle), split.getConnectorSplit(), table.getConnectorHandle(), columns, dynamicFilter);
    }
}

