/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spiller;

import io.airlift.configuration.Config;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import jakarta.validation.constraints.NotNull;

public class NodeSpillConfig {
    private DataSize maxSpillPerNode = DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private DataSize queryMaxSpillPerNode = DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private boolean spillCompressionEnabled;
    private boolean spillEncryptionEnabled;

    @NotNull
    public DataSize getMaxSpillPerNode() {
        return this.maxSpillPerNode;
    }

    @Config(value="max-spill-per-node")
    @LegacyConfig(value={"experimental.max-spill-per-node"})
    public NodeSpillConfig setMaxSpillPerNode(DataSize maxSpillPerNode) {
        this.maxSpillPerNode = maxSpillPerNode;
        return this;
    }

    @NotNull
    public DataSize getQueryMaxSpillPerNode() {
        return this.queryMaxSpillPerNode;
    }

    @Config(value="query-max-spill-per-node")
    @LegacyConfig(value={"experimental.query-max-spill-per-node"})
    public NodeSpillConfig setQueryMaxSpillPerNode(DataSize queryMaxSpillPerNode) {
        this.queryMaxSpillPerNode = queryMaxSpillPerNode;
        return this;
    }

    public boolean isSpillCompressionEnabled() {
        return this.spillCompressionEnabled;
    }

    @Config(value="spill-compression-enabled")
    @LegacyConfig(value={"experimental.spill-compression-enabled"})
    public NodeSpillConfig setSpillCompressionEnabled(boolean spillCompressionEnabled) {
        this.spillCompressionEnabled = spillCompressionEnabled;
        return this;
    }

    public boolean isSpillEncryptionEnabled() {
        return this.spillEncryptionEnabled;
    }

    @Config(value="spill-encryption-enabled")
    @LegacyConfig(value={"experimental.spill-encryption-enabled"})
    public NodeSpillConfig setSpillEncryptionEnabled(boolean spillEncryptionEnabled) {
        this.spillEncryptionEnabled = spillEncryptionEnabled;
        return this;
    }
}

