/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.connector.system.KillQueryProcedure;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlUtil;
import io.trino.server.BasicQueryInfo;
import io.trino.server.HttpRequestSessionContextFactory;
import io.trino.server.ProtocolConfig;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.ui.TrimmedBasicQueryInfo;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoException;
import io.trino.spi.security.AccessDeniedException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

@Path(value="/ui/api/query")
public class UiQueryResource {
    private final DispatchManager dispatchManager;
    private final AccessControl accessControl;
    private final HttpRequestSessionContextFactory sessionContextFactory;
    private final Optional<String> alternateHeaderName;

    @Inject
    public UiQueryResource(DispatchManager dispatchManager, AccessControl accessControl, HttpRequestSessionContextFactory sessionContextFactory, ProtocolConfig protocolConfig) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionContextFactory = Objects.requireNonNull(sessionContextFactory, "sessionContextFactory is null");
        this.alternateHeaderName = protocolConfig.getAlternateHeaderName();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @GET
    public List<TrimmedBasicQueryInfo> getAllQueryInfo(@QueryParam(value="state") String stateFilter, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        QueryState expectedState = stateFilter == null ? null : QueryState.valueOf(stateFilter.toUpperCase(Locale.ENGLISH));
        List<BasicQueryInfo> queries = this.dispatchManager.getQueries();
        queries = AccessControlUtil.filterQueries(this.sessionContextFactory.extractAuthorizedIdentity(servletRequest, httpHeaders, this.alternateHeaderName), queries, this.accessControl);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BasicQueryInfo queryInfo : queries) {
            if (stateFilter != null && queryInfo.getState() != expectedState) continue;
            builder.add((Object)new TrimmedBasicQueryInfo(queryInfo));
        }
        return builder.build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @GET
    @Path(value="{queryId}")
    public Response getQueryInfo(@PathParam(value="queryId") QueryId queryId, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        Objects.requireNonNull(queryId, "queryId is null");
        Optional<QueryInfo> queryInfo = this.dispatchManager.getFullQueryInfo(queryId);
        if (queryInfo.isPresent()) {
            try {
                AccessControlUtil.checkCanViewQueryOwnedBy(this.sessionContextFactory.extractAuthorizedIdentity(servletRequest, httpHeaders, this.alternateHeaderName), queryInfo.get().getSession().toIdentity(), this.accessControl);
                return Response.ok((Object)queryInfo.get()).build();
            }
            catch (AccessDeniedException e) {
                throw new ForbiddenException();
            }
        }
        return Response.status((Response.Status)Response.Status.GONE).build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @PUT
    @Path(value="{queryId}/killed")
    public Response killQuery(@PathParam(value="queryId") QueryId queryId, String message, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        return this.failQuery(queryId, KillQueryProcedure.createKillQueryException(message), servletRequest, httpHeaders);
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @PUT
    @Path(value="{queryId}/preempted")
    public Response preemptQuery(@PathParam(value="queryId") QueryId queryId, String message, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        return this.failQuery(queryId, KillQueryProcedure.createPreemptQueryException(message), servletRequest, httpHeaders);
    }

    private Response failQuery(QueryId queryId, TrinoException queryException, HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        Objects.requireNonNull(queryId, "queryId is null");
        try {
            BasicQueryInfo queryInfo = this.dispatchManager.getQueryInfo(queryId);
            AccessControlUtil.checkCanKillQueryOwnedBy(this.sessionContextFactory.extractAuthorizedIdentity(servletRequest, httpHeaders, this.alternateHeaderName), queryInfo.getSession().toIdentity(), this.accessControl);
            if (queryInfo.getState().isDone()) {
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            this.dispatchManager.failQuery(queryId, (Throwable)queryException);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        catch (AccessDeniedException e) {
            throw new ForbiddenException();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
    }
}

