/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.server.security.PasswordAuthenticatorConfig;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.server.security.SecurityConfig;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import io.trino.server.ui.FormAuthenticator;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.PasswordAuthenticator;
import java.security.Principal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PasswordManagerFormAuthenticator
implements FormAuthenticator {
    private static final Logger log = Logger.get(PasswordManagerFormAuthenticator.class);
    private final PasswordAuthenticatorManager passwordAuthenticatorManager;
    private final UserMapping userMapping;
    private final boolean insecureAuthenticationOverHttpAllowed;

    @Inject
    public PasswordManagerFormAuthenticator(PasswordAuthenticatorManager passwordAuthenticatorManager, PasswordAuthenticatorConfig config, SecurityConfig securityConfig) {
        this.passwordAuthenticatorManager = Objects.requireNonNull(passwordAuthenticatorManager, "passwordAuthenticatorManager is null");
        passwordAuthenticatorManager.setRequired();
        this.userMapping = UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile());
        this.insecureAuthenticationOverHttpAllowed = securityConfig.isInsecureAuthenticationOverHttpAllowed();
    }

    @Override
    public boolean isLoginEnabled(boolean secure) {
        if (secure) {
            return true;
        }
        return this.insecureAuthenticationOverHttpAllowed;
    }

    @Override
    public boolean isPasswordAllowed(boolean secure) {
        return secure;
    }

    @Override
    public Optional<String> isValidCredential(String username, String password, boolean secure) {
        if (username == null) {
            return Optional.empty();
        }
        if (!secure) {
            return Optional.of(username).filter(user -> this.insecureAuthenticationOverHttpAllowed && password == null);
        }
        List<PasswordAuthenticator> authenticators = this.passwordAuthenticatorManager.getAuthenticators();
        for (PasswordAuthenticator authenticator : authenticators) {
            try {
                Principal principal = authenticator.createAuthenticatedPrincipal(username, password);
                String authenticatedUser = this.userMapping.mapUser(principal.toString());
                return Optional.of(authenticatedUser);
            }
            catch (UserMappingException | AccessDeniedException principal) {
            }
            catch (RuntimeException e) {
                log.debug((Throwable)e, "Error authenticating user for Web UI");
            }
        }
        return Optional.empty();
    }
}

