/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.inject.Inject;
import io.trino.server.ServletSecurityUtils;
import io.trino.server.ui.FixedUserWebUiConfig;
import io.trino.server.ui.FormWebUiAuthenticationFilter;
import io.trino.server.ui.WebUiAuthenticationFilter;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.security.Principal;
import java.util.Objects;

public class FixedUserWebUiAuthenticationFilter
implements WebUiAuthenticationFilter {
    private final Identity webUiIdentity;

    @Inject
    public FixedUserWebUiAuthenticationFilter(FixedUserWebUiConfig config) {
        this(FixedUserWebUiAuthenticationFilter.basicIdentity(config.getUsername()));
    }

    public FixedUserWebUiAuthenticationFilter(Identity webUiIdentity) {
        this.webUiIdentity = Objects.requireNonNull(webUiIdentity, "webUiIdentity is null");
    }

    public void filter(ContainerRequestContext request) {
        if (FormWebUiAuthenticationFilter.redirectAllFormLoginToUi(request)) {
            return;
        }
        ServletSecurityUtils.setAuthenticatedIdentity(request, this.webUiIdentity);
    }

    private static Identity basicIdentity(String username) {
        Objects.requireNonNull(username, "username is null");
        return Identity.forUser((String)username).withPrincipal((Principal)new BasicPrincipal(username)).build();
    }
}

