/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import io.trino.server.security.oauth2.OAuth2Client;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

public interface TokenPairSerializer {
    public static final TokenPairSerializer ACCESS_TOKEN_ONLY_SERIALIZER = new TokenPairSerializer(){

        @Override
        public TokenPair deserialize(String token) {
            return TokenPair.withAccessToken(token);
        }

        @Override
        public String serialize(TokenPair tokenPair) {
            return tokenPair.accessToken();
        }
    };

    public TokenPair deserialize(String var1);

    public String serialize(TokenPair var1);

    public record TokenPair(String accessToken, Date expiration, Optional<String> refreshToken) {
        public TokenPair {
            Objects.requireNonNull(accessToken, "accessToken is nul");
            Objects.requireNonNull(expiration, "expiration is null");
            Objects.requireNonNull(refreshToken, "refreshToken is null");
        }

        public static TokenPair withAccessToken(String accessToken) {
            return new TokenPair(accessToken, new Date(Long.MAX_VALUE), Optional.empty());
        }

        public static TokenPair fromOAuth2Response(OAuth2Client.Response tokens) {
            Objects.requireNonNull(tokens, "tokens is null");
            return new TokenPair(tokens.getAccessToken(), Date.from(tokens.getExpiration()), tokens.getRefreshToken());
        }

        public static TokenPair withAccessAndRefreshTokens(String accessToken, Date expiration, @Nullable String refreshToken) {
            return new TokenPair(accessToken, expiration, Optional.ofNullable(refreshToken));
        }
    }
}

