/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;

public class StaticOAuth2ServerConfiguration {
    public static final String ACCESS_TOKEN_ISSUER = "http-server.authentication.oauth2.access-token-issuer";
    public static final String AUTH_URL = "http-server.authentication.oauth2.auth-url";
    public static final String TOKEN_URL = "http-server.authentication.oauth2.token-url";
    public static final String JWKS_URL = "http-server.authentication.oauth2.jwks-url";
    public static final String USERINFO_URL = "http-server.authentication.oauth2.userinfo-url";
    private Optional<String> accessTokenIssuer = Optional.empty();
    private String authUrl;
    private String tokenUrl;
    private String jwksUrl;
    private Optional<String> userinfoUrl = Optional.empty();

    @NotNull
    public Optional<String> getAccessTokenIssuer() {
        return this.accessTokenIssuer;
    }

    @Config(value="http-server.authentication.oauth2.access-token-issuer")
    @ConfigDescription(value="The required issuer for access tokens")
    public StaticOAuth2ServerConfiguration setAccessTokenIssuer(String accessTokenIssuer) {
        this.accessTokenIssuer = Optional.ofNullable(accessTokenIssuer);
        return this;
    }

    @NotNull
    public String getAuthUrl() {
        return this.authUrl;
    }

    @Config(value="http-server.authentication.oauth2.auth-url")
    @ConfigDescription(value="URL of the authorization server's authorization endpoint")
    public StaticOAuth2ServerConfiguration setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
        return this;
    }

    @NotNull
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @Config(value="http-server.authentication.oauth2.token-url")
    @ConfigDescription(value="URL of the authorization server's token endpoint")
    public StaticOAuth2ServerConfiguration setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        return this;
    }

    @NotNull
    public String getJwksUrl() {
        return this.jwksUrl;
    }

    @Config(value="http-server.authentication.oauth2.jwks-url")
    @ConfigDescription(value="URL of the authorization server's JWKS (JSON Web Key Set) endpoint")
    public StaticOAuth2ServerConfiguration setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
        return this;
    }

    public Optional<String> getUserinfoUrl() {
        return this.userinfoUrl;
    }

    @Config(value="http-server.authentication.oauth2.userinfo-url")
    @ConfigDescription(value="URL of the userinfo endpoint")
    public StaticOAuth2ServerConfiguration setUserinfoUrl(String userinfoUrl) {
        this.userinfoUrl = Optional.ofNullable(userinfoUrl);
        return this;
    }
}

