/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;

public interface OAuth2ServerConfigProvider {
    public OAuth2ServerConfig get();

    public static class OAuth2ServerConfig {
        private final Optional<String> accessTokenIssuer;
        private final URI authUrl;
        private final URI tokenUrl;
        private final URI jwksUrl;
        private final Optional<URI> userinfoUrl;

        public OAuth2ServerConfig(Optional<String> accessTokenIssuer, URI authUrl, URI tokenUrl, URI jwksUrl, Optional<URI> userinfoUrl) {
            this.accessTokenIssuer = Objects.requireNonNull(accessTokenIssuer, "accessTokenIssuer is null");
            this.authUrl = Objects.requireNonNull(authUrl, "authUrl is null");
            this.tokenUrl = Objects.requireNonNull(tokenUrl, "tokenUrl is null");
            this.jwksUrl = Objects.requireNonNull(jwksUrl, "jwksUrl is null");
            this.userinfoUrl = Objects.requireNonNull(userinfoUrl, "userinfoUrl is null");
        }

        public Optional<String> getAccessTokenIssuer() {
            return this.accessTokenIssuer;
        }

        public URI getAuthUrl() {
            return this.authUrl;
        }

        public URI getTokenUrl() {
            return this.tokenUrl;
        }

        public URI getJwksUrl() {
            return this.jwksUrl;
        }

        public Optional<URI> getUserinfoUrl() {
            return this.userinfoUrl;
        }
    }
}

