/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.base.Verify;
import com.google.inject.Inject;
import io.trino.client.ProtocolDetectionException;
import io.trino.client.ProtocolHeaders;
import io.trino.server.ProtocolConfig;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.Authenticator;
import io.trino.server.security.BasicAuthCredentials;
import io.trino.server.security.PasswordAuthenticatorConfig;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.MultivaluedMap;
import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PasswordAuthenticator
implements Authenticator {
    private final PasswordAuthenticatorManager authenticatorManager;
    private final UserMapping userMapping;
    private final Optional<String> alternateHeaderName;

    @Inject
    public PasswordAuthenticator(PasswordAuthenticatorManager authenticatorManager, PasswordAuthenticatorConfig config, ProtocolConfig protocolConfig) {
        this.userMapping = UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile());
        this.authenticatorManager = Objects.requireNonNull(authenticatorManager, "authenticatorManager is null");
        authenticatorManager.setRequired();
        this.alternateHeaderName = protocolConfig.getAlternateHeaderName();
    }

    @Override
    public Identity authenticate(ContainerRequestContext request) throws AuthenticationException {
        BasicAuthCredentials basicAuthCredentials = BasicAuthCredentials.extractBasicAuthCredentials(request).orElseThrow(() -> PasswordAuthenticator.needAuthentication(null));
        String user = basicAuthCredentials.getUser();
        String password = basicAuthCredentials.getPassword().orElseThrow(() -> new AuthenticationException("Malformed credentials: password is empty"));
        AuthenticationException exception = null;
        for (io.trino.spi.security.PasswordAuthenticator authenticator : this.authenticatorManager.getAuthenticators()) {
            try {
                Principal principal = authenticator.createAuthenticatedPrincipal(user, password);
                String authenticatedUser = this.userMapping.mapUser(principal.toString());
                this.rewriteUserHeaderToMappedUser(basicAuthCredentials, (MultivaluedMap<String, String>)request.getHeaders(), authenticatedUser);
                return Identity.forUser((String)authenticatedUser).withPrincipal(principal).build();
            }
            catch (UserMappingException | AccessDeniedException e) {
                if (exception == null) {
                    exception = PasswordAuthenticator.needAuthentication(e.getMessage());
                    continue;
                }
                exception.addSuppressed(PasswordAuthenticator.needAuthentication(e.getMessage()));
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Authentication error", e);
            }
        }
        Verify.verify((exception != null ? 1 : 0) != 0, (String)"exception not set", (Object[])new Object[0]);
        throw exception;
    }

    private void rewriteUserHeaderToMappedUser(BasicAuthCredentials basicAuthCredentials, MultivaluedMap<String, String> headers, String authenticatedUser) {
        String userHeader;
        try {
            userHeader = ProtocolHeaders.detectProtocol(this.alternateHeaderName, (Set)headers.keySet()).requestUser();
        }
        catch (ProtocolDetectionException ignored) {
            return;
        }
        if (basicAuthCredentials.getUser().equals(headers.getFirst((Object)userHeader))) {
            headers.putSingle((Object)userHeader, (Object)authenticatedUser);
        }
    }

    private static AuthenticationException needAuthentication(String message) {
        return new AuthenticationException(message, "Basic realm=\"Trino\"");
    }
}

