/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.validation.FileExists;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.util.List;
import java.util.Optional;

public class HeaderAuthenticatorConfig {
    private Optional<String> userMappingPattern = Optional.empty();
    private Optional<File> userMappingFile = Optional.empty();
    private List<File> headerAuthenticatorFiles = ImmutableList.of((Object)new File("etc/header-authenticator.properties"));

    @Config(value="http-server.authentication.header.user-mapping.pattern")
    @ConfigDescription(value="An optional user mapping pattern to be applied to the authenticated principal")
    public HeaderAuthenticatorConfig setUserMappingPattern(String userMappingPattern) {
        this.userMappingPattern = Optional.ofNullable(userMappingPattern);
        return this;
    }

    public Optional<String> getUserMappingPattern() {
        return this.userMappingPattern;
    }

    @Config(value="http-server.authentication.header.user-mapping.file")
    @ConfigDescription(value="An optional user mapping file containing the mapping rules to be applied to the authenticated principal")
    public HeaderAuthenticatorConfig setUserMappingFile(File userMappingFile) {
        this.userMappingFile = Optional.ofNullable(userMappingFile);
        return this;
    }

    public Optional<@FileExists File> getUserMappingFile() {
        return this.userMappingFile;
    }

    @Config(value="header-authenticator.config-files")
    @ConfigDescription(value="Ordered list of header authenticator configuration files")
    public HeaderAuthenticatorConfig setHeaderAuthenticatorFiles(List<String> headerAuthenticatorFiles) {
        this.headerAuthenticatorFiles = (List)headerAuthenticatorFiles.stream().map(File::new).collect(ImmutableList.toImmutableList());
        return this;
    }

    @NotNull
    @NotEmpty(message="At least one header authenticator config file is required")
    public @NotNull @NotEmpty(message="At least one header authenticator config file is required") List<@FileExists File> getHeaderAuthenticatorFiles() {
        return this.headerAuthenticatorFiles;
    }
}

