/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.remotetask;

import com.google.common.net.MediaType;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.concurrent.SetThreadName;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.SpanBuilder;
import io.trino.execution.DynamicFiltersCollector;
import io.trino.execution.TaskId;
import io.trino.server.DynamicFilterService;
import io.trino.server.remotetask.RemoteTaskStats;
import io.trino.server.remotetask.RequestErrorTracker;
import io.trino.server.remotetask.SimpleHttpResponseCallback;
import io.trino.server.remotetask.SimpleHttpResponseHandler;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;

class DynamicFiltersFetcher {
    private final TaskId taskId;
    private final URI taskUri;
    private final Consumer<Throwable> onFail;
    private final JsonCodec<DynamicFiltersCollector.VersionedDynamicFilterDomains> dynamicFilterDomainsCodec;
    private final Duration refreshMaxWait;
    private final Executor executor;
    private final HttpClient httpClient;
    private final Supplier<SpanBuilder> spanBuilderFactory;
    private final RequestErrorTracker errorTracker;
    private final RemoteTaskStats stats;
    private final DynamicFilterService dynamicFilterService;
    @GuardedBy(value="this")
    private long dynamicFiltersVersion = 0L;
    @GuardedBy(value="this")
    private long localDynamicFiltersVersion = 0L;
    @GuardedBy(value="this")
    private boolean running;
    @GuardedBy(value="this")
    private ListenableFuture<FullJsonResponseHandler.JsonResponse<DynamicFiltersCollector.VersionedDynamicFilterDomains>> future;

    public DynamicFiltersFetcher(Consumer<Throwable> onFail, TaskId taskId, URI taskUri, Duration refreshMaxWait, JsonCodec<DynamicFiltersCollector.VersionedDynamicFilterDomains> dynamicFilterDomainsCodec, Executor executor, HttpClient httpClient, Supplier<SpanBuilder> spanBuilderFactory, Duration maxErrorDuration, ScheduledExecutorService errorScheduledExecutor, RemoteTaskStats stats, DynamicFilterService dynamicFilterService) {
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.taskUri = Objects.requireNonNull(taskUri, "taskUri is null");
        this.onFail = Objects.requireNonNull(onFail, "onFail is null");
        this.refreshMaxWait = Objects.requireNonNull(refreshMaxWait, "refreshMaxWait is null");
        this.dynamicFilterDomainsCodec = Objects.requireNonNull(dynamicFilterDomainsCodec, "dynamicFilterDomainsCodec is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.spanBuilderFactory = Objects.requireNonNull(spanBuilderFactory, "spanBuilderFactory is null");
        this.errorTracker = new RequestErrorTracker(taskId, taskUri, maxErrorDuration, errorScheduledExecutor, "getting dynamic filter domains");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.dynamicFilterService = Objects.requireNonNull(dynamicFilterService, "dynamicFilterService is null");
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.fetchDynamicFiltersIfNecessary();
    }

    public synchronized void updateDynamicFiltersVersionAndFetchIfNecessary(long newDynamicFiltersVersion) {
        if (this.dynamicFiltersVersion >= newDynamicFiltersVersion) {
            return;
        }
        this.dynamicFiltersVersion = newDynamicFiltersVersion;
        this.fetchDynamicFiltersIfNecessary();
    }

    private synchronized void fetchDynamicFiltersIfNecessary() {
        if (!this.running) {
            return;
        }
        if (this.localDynamicFiltersVersion >= this.dynamicFiltersVersion) {
            return;
        }
        if (this.future != null && !this.future.isDone()) {
            return;
        }
        ListenableFuture<Void> errorRateLimit = this.errorTracker.acquireRequestPermit();
        if (!errorRateLimit.isDone()) {
            errorRateLimit.addListener(this::fetchDynamicFiltersIfNecessary, this.executor);
            return;
        }
        Request request = Request.Builder.prepareGet().setUri(HttpUriBuilder.uriBuilderFrom((URI)this.taskUri).appendPath("dynamicfilters").build()).setHeader("Content-Type", MediaType.JSON_UTF_8.toString()).setHeader("X-Trino-Current-Version", Long.toString(this.localDynamicFiltersVersion)).setHeader("X-Trino-Max-Wait", this.refreshMaxWait.toString()).setSpanBuilder(this.spanBuilderFactory.get()).build();
        this.errorTracker.startRequest();
        this.future = this.httpClient.executeAsync(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(this.dynamicFilterDomainsCodec));
        Futures.addCallback(this.future, new SimpleHttpResponseHandler<DynamicFiltersCollector.VersionedDynamicFilterDomains>(new DynamicFiltersResponseCallback(), request.getUri(), this.stats), (Executor)this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDynamicFilterDomains(DynamicFiltersCollector.VersionedDynamicFilterDomains newDynamicFilterDomains) {
        DynamicFiltersFetcher dynamicFiltersFetcher = this;
        synchronized (dynamicFiltersFetcher) {
            if (this.localDynamicFiltersVersion >= newDynamicFilterDomains.getVersion()) {
                return;
            }
            this.localDynamicFiltersVersion = newDynamicFilterDomains.getVersion();
            if (this.dynamicFiltersVersion < this.localDynamicFiltersVersion) {
                this.dynamicFiltersVersion = this.localDynamicFiltersVersion;
            }
        }
        this.dynamicFilterService.addTaskDynamicFilters(this.taskId, newDynamicFilterDomains.getDynamicFilterDomains());
    }

    private void updateStats(long currentRequestStartNanos) {
        this.stats.statusRoundTripMillis(Duration.nanosSince((long)currentRequestStartNanos).toMillis());
    }

    private class DynamicFiltersResponseCallback
    implements SimpleHttpResponseCallback<DynamicFiltersCollector.VersionedDynamicFilterDomains> {
        private final long requestStartNanos = System.nanoTime();

        private DynamicFiltersResponseCallback() {
        }

        @Override
        public void success(DynamicFiltersCollector.VersionedDynamicFilterDomains newDynamicFilterDomains) {
            try (SetThreadName ignored = new SetThreadName("DynamicFiltersFetcher-%s", new Object[]{DynamicFiltersFetcher.this.taskId});){
                DynamicFiltersFetcher.this.updateStats(this.requestStartNanos);
                try {
                    DynamicFiltersFetcher.this.updateDynamicFilterDomains(newDynamicFilterDomains);
                    DynamicFiltersFetcher.this.errorTracker.requestSucceeded();
                }
                finally {
                    DynamicFiltersFetcher.this.fetchDynamicFiltersIfNecessary();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable cause) {
            try (SetThreadName ignored = new SetThreadName("DynamicFiltersFetcher-%s", new Object[]{DynamicFiltersFetcher.this.taskId});){
                DynamicFiltersFetcher.this.updateStats(this.requestStartNanos);
                try {
                    DynamicFiltersFetcher.this.errorTracker.requestFailed(cause);
                }
                catch (Error e) {
                    DynamicFiltersFetcher.this.onFail.accept(e);
                    throw e;
                }
                catch (RuntimeException e) {
                    DynamicFiltersFetcher.this.onFail.accept(e);
                }
                finally {
                    DynamicFiltersFetcher.this.fetchDynamicFiltersIfNecessary();
                }
            }
        }

        @Override
        public void fatal(Throwable cause) {
            try (SetThreadName ignored = new SetThreadName("DynamicFiltersFetcher-%s", new Object[]{DynamicFiltersFetcher.this.taskId});){
                DynamicFiltersFetcher.this.updateStats(this.requestStartNanos);
                DynamicFiltersFetcher.this.onFail.accept(cause);
            }
        }
    }
}

