/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.trino.Session;
import io.trino.client.ClientCapabilities;
import io.trino.client.Column;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class QueryResultRows
implements Iterable<List<Object>> {
    private final ConnectorSession session;
    private final Optional<List<ColumnAndType>> columns;
    private final List<Page> pages;
    private final Optional<Consumer<Throwable>> exceptionConsumer;
    private final long totalRows;
    private final boolean supportsParametricDateTime;

    private QueryResultRows(Session session, Optional<List<ColumnAndType>> columns, List<Page> pages, Consumer<Throwable> exceptionConsumer) {
        this.session = session.toConnectorSession();
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.pages = ImmutableList.copyOf(pages);
        this.exceptionConsumer = Optional.ofNullable(exceptionConsumer);
        this.totalRows = QueryResultRows.countRows(pages);
        this.supportsParametricDateTime = session.getClientCapabilities().contains(ClientCapabilities.PARAMETRIC_DATETIME.toString());
        Verify.verify((this.totalRows == 0L || this.totalRows > 0L && columns.isPresent() ? 1 : 0) != 0, (String)"data present without columns and types", (Object[])new Object[0]);
    }

    public boolean isEmpty() {
        return this.totalRows == 0L;
    }

    public Optional<List<Column>> getColumns() {
        return this.columns.map(columns -> (List)columns.stream().map(ColumnAndType::getColumn).collect(ImmutableList.toImmutableList()));
    }

    @VisibleForTesting
    public long getTotalRowsCount() {
        return this.totalRows;
    }

    public Optional<Long> getUpdateCount() {
        if (this.totalRows != 1L || this.columns.isEmpty()) {
            return Optional.empty();
        }
        List<ColumnAndType> columns = this.columns.get();
        if (columns.size() != 1 || !columns.get(0).getType().equals(BigintType.BIGINT)) {
            return Optional.empty();
        }
        Preconditions.checkState((!this.pages.isEmpty() ? 1 : 0) != 0, (Object)"no data pages available");
        Number value = (Number)columns.get(0).getType().getObjectValue(this.session, this.pages.get(0).getBlock(0), 0);
        return Optional.ofNullable(value).map(Number::longValue);
    }

    @Override
    public Iterator<List<Object>> iterator() {
        return new ResultsIterator(this);
    }

    private static long countRows(List<Page> pages) {
        long rows = 0L;
        for (Page page : pages) {
            rows += (long)page.getPositionCount();
        }
        return rows;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columns", this.columns).add("totalRowsCount", this.getTotalRowsCount()).add("pagesCount", this.pages.size()).toString();
    }

    public static QueryResultRows empty(Session session) {
        return new QueryResultRows(session, Optional.empty(), (List<Page>)ImmutableList.of(), null);
    }

    public static Builder queryResultRowsBuilder(Session session) {
        return new Builder(session);
    }

    private static class ColumnAndType {
        private final int position;
        private final Column column;
        private final Type type;

        private ColumnAndType(int position, Column column, Type type) {
            this.position = position;
            this.column = column;
            this.type = type;
        }

        public Column getColumn() {
            return this.column;
        }

        public Type getType() {
            return this.type;
        }

        public int getPosition() {
            return this.position;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("column", (Object)this.column).add("type", (Object)this.type).add("position", this.position).toString();
        }
    }

    private static class ResultsIterator
    extends AbstractIterator<List<Object>> {
        private final Deque<Page> queue;
        private final QueryResultRows results;
        private Page currentPage;
        private int rowPosition = -1;
        private int inPageIndex = -1;

        public ResultsIterator(QueryResultRows results) {
            this.queue = new ArrayDeque<Page>(results.pages);
            this.results = results;
            this.currentPage = this.queue.pollFirst();
        }

        protected List<Object> computeNext() {
            List<Object> row;
            do {
                if (this.currentPage == null) {
                    return (List)this.endOfData();
                }
                ++this.inPageIndex;
                if (this.inPageIndex >= this.currentPage.getPositionCount()) {
                    this.currentPage = this.queue.pollFirst();
                    if (this.currentPage == null) {
                        return (List)this.endOfData();
                    }
                    this.inPageIndex = 0;
                }
                ++this.rowPosition;
            } while ((row = this.getRowValues()) == null);
            return row;
        }

        @Nullable
        private List<Object> getRowValues() {
            List<ColumnAndType> columns = this.results.columns.orElseThrow();
            Object[] row = new Object[this.currentPage.getChannelCount()];
            for (int channel = 0; channel < this.currentPage.getChannelCount(); ++channel) {
                ColumnAndType column = columns.get(channel);
                Type type = column.getType();
                Block block = this.currentPage.getBlock(channel);
                try {
                    Object value = type.getObjectValue(this.results.session, block, this.inPageIndex);
                    if (!this.results.supportsParametricDateTime) {
                        value = this.getLegacyValue(value, type);
                    }
                    row[channel] = value;
                    continue;
                }
                catch (Throwable throwable) {
                    this.propagateException(this.rowPosition, column, throwable);
                    return null;
                }
            }
            return Collections.unmodifiableList(Arrays.asList(row));
        }

        private Object getLegacyValue(Object value, Type type) {
            if (value == null) {
                return null;
            }
            if (!this.results.supportsParametricDateTime) {
                if (type instanceof TimestampType) {
                    return ((SqlTimestamp)value).roundTo(3);
                }
                if (type instanceof TimestampWithTimeZoneType) {
                    return ((SqlTimestampWithTimeZone)value).roundTo(3);
                }
                if (type instanceof TimeType) {
                    return ((SqlTime)value).roundTo(3);
                }
                if (type instanceof TimeWithTimeZoneType) {
                    return ((SqlTimeWithTimeZone)value).roundTo(3);
                }
            }
            if (type instanceof ArrayType) {
                Type elementType = ((ArrayType)type).getElementType();
                if (!(elementType instanceof TimestampType) && !(elementType instanceof TimestampWithTimeZoneType)) {
                    return value;
                }
                List listValue = (List)value;
                ArrayList<Object> legacyValues = new ArrayList<Object>(listValue.size());
                for (Object element : listValue) {
                    legacyValues.add(this.getLegacyValue(element, elementType));
                }
                return Collections.unmodifiableList(legacyValues);
            }
            if (type instanceof MapType) {
                Type keyType = ((MapType)type).getKeyType();
                Type valueType = ((MapType)type).getValueType();
                Map mapValue = (Map)value;
                HashMap result = Maps.newHashMapWithExpectedSize((int)mapValue.size());
                mapValue.forEach((key, val) -> result.put(this.getLegacyValue(key, keyType), this.getLegacyValue(val, valueType)));
                return Collections.unmodifiableMap(result);
            }
            if (type instanceof RowType) {
                List fields = ((RowType)type).getFields();
                List values = (List)value;
                ArrayList<Object> result = new ArrayList<Object>(values.size());
                for (int i = 0; i < values.size(); ++i) {
                    result.add(this.getLegacyValue(values.get(i), ((RowType.Field)fields.get(i)).getType()));
                }
                return Collections.unmodifiableList(result);
            }
            return value;
        }

        private void propagateException(int row, ColumnAndType column, Throwable cause) {
            String message = String.format("Could not serialize column '%s' of type '%s' at position %d:%d", column.getColumn().getName(), column.getType(), row + 1, column.getPosition() + 1);
            this.results.exceptionConsumer.ifPresent(consumer -> consumer.accept(new TrinoException((ErrorCodeSupplier)StandardErrorCode.SERIALIZATION_ERROR, message, cause)));
        }
    }

    public static class Builder {
        private final Session session;
        private ImmutableList.Builder<Page> pages = ImmutableList.builder();
        private Optional<List<ColumnAndType>> columns = Optional.empty();
        private Consumer<Throwable> exceptionConsumer;

        public Builder(Session session) {
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public Builder addPage(Page page) {
            this.pages.add((Object)page);
            return this;
        }

        public Builder addPages(List<Page> page) {
            this.pages.addAll(page);
            return this;
        }

        public Builder withColumnsAndTypes(@Nullable List<Column> columns, @Nullable List<Type> types) {
            if (columns != null || types != null) {
                this.columns = Optional.of(Builder.combine(columns, types));
            }
            return this;
        }

        public Builder withSingleBooleanValue(Column column, boolean value) {
            BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(null, 1);
            BooleanType.BOOLEAN.writeBoolean(blockBuilder, value);
            this.pages = ImmutableList.builder().add((Object)new Page(new Block[]{blockBuilder.build()}));
            this.columns = Optional.of(Builder.combine((List<Column>)ImmutableList.of((Object)column), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)));
            return this;
        }

        public Builder withExceptionConsumer(Consumer<Throwable> exceptionConsumer) {
            this.exceptionConsumer = exceptionConsumer;
            return this;
        }

        public QueryResultRows build() {
            return new QueryResultRows(this.session, this.columns, (List<Page>)this.pages.build(), this.exceptionConsumer);
        }

        private static List<ColumnAndType> combine(@Nullable List<Column> columns, @Nullable List<Type> types) {
            Preconditions.checkArgument((columns != null && types != null ? 1 : 0) != 0, (Object)"columns and types must be present at the same time");
            Preconditions.checkArgument((columns.size() == types.size() ? 1 : 0) != 0, (Object)"columns and types size mismatch");
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)columns.size());
            for (int i = 0; i < columns.size(); ++i) {
                builder.add((Object)new ColumnAndType(i, columns.get(i), types.get(i)));
            }
            return builder.build();
        }
    }
}

