/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.base.Verify;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.security.ForwardingAccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ViewAccessControl
extends ForwardingAccessControl {
    private final AccessControl delegate;
    private final Identity invoker;

    public ViewAccessControl(AccessControl delegate, Identity invoker) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.invoker = Objects.requireNonNull(invoker, "invoker is null");
    }

    @Override
    protected AccessControl delegate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkCanSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        ViewAccessControl.wrapAccessDeniedException(() -> this.delegate.checkCanCreateViewWithSelectFromColumns(context, tableName, columnNames));
    }

    @Override
    public Set<String> filterColumns(SecurityContext context, CatalogSchemaTableName tableName, Set<String> columns) {
        return this.delegate.filterColumns(context, tableName, columns);
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        ViewAccessControl.wrapAccessDeniedException(() -> this.delegate.checkCanCreateViewWithSelectFromColumns(context, tableName, columnNames));
    }

    @Override
    public void checkCanExecuteFunction(SecurityContext context, String functionName) {
        ViewAccessControl.wrapAccessDeniedException(() -> this.delegate.checkCanGrantExecuteFunctionPrivilege(context, functionName, this.invoker, false));
    }

    @Override
    public void checkCanExecuteFunction(SecurityContext context, FunctionKind functionKind, QualifiedObjectName functionName) {
        ViewAccessControl.wrapAccessDeniedException(() -> this.delegate.checkCanGrantExecuteFunctionPrivilege(context, functionKind, functionName, this.invoker, false));
    }

    @Override
    public void checkCanGrantExecuteFunctionPrivilege(SecurityContext context, String functionName, Identity grantee, boolean grantOption) {
        ViewAccessControl.wrapAccessDeniedException(() -> this.delegate.checkCanGrantExecuteFunctionPrivilege(context, functionName, grantee, grantOption));
    }

    @Override
    public List<ViewExpression> getRowFilters(SecurityContext context, QualifiedObjectName tableName) {
        return this.delegate.getRowFilters(context, tableName);
    }

    @Override
    public Optional<ViewExpression> getColumnMask(SecurityContext context, QualifiedObjectName tableName, String columnName, Type type) {
        return this.delegate.getColumnMask(context, tableName, columnName, type);
    }

    private static void wrapAccessDeniedException(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (AccessDeniedException e) {
            String prefix = "Access Denied: ";
            Verify.verify((boolean)e.getMessage().startsWith(prefix));
            String msg = e.getMessage().substring(prefix.length());
            throw new AccessDeniedException("View owner does not have sufficient privileges: " + msg, e);
        }
    }
}

