/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableList;
import io.trino.SessionRepresentation;
import io.trino.security.AccessControl;
import io.trino.server.BasicQueryInfo;
import io.trino.spi.security.Identity;
import java.util.Collection;
import java.util.List;

public final class AccessControlUtil {
    private AccessControlUtil() {
    }

    public static void checkCanViewQueryOwnedBy(Identity identity, Identity queryOwner, AccessControl accessControl) {
        if (identity.getUser().equals(queryOwner.getUser())) {
            return;
        }
        accessControl.checkCanViewQueryOwnedBy(identity, queryOwner);
    }

    public static List<BasicQueryInfo> filterQueries(Identity identity, List<BasicQueryInfo> queries, AccessControl accessControl) {
        Collection owners = (Collection)queries.stream().map(BasicQueryInfo::getSession).map(SessionRepresentation::toIdentity).filter(owner -> !owner.getUser().equals(identity.getUser())).distinct().collect(ImmutableList.toImmutableList());
        Collection<Identity> allowedOwners = accessControl.filterQueriesOwnedBy(identity, owners);
        return (List)queries.stream().filter(queryInfo -> {
            Identity queryIdentity = queryInfo.getSession().toIdentity();
            return queryIdentity.getUser().equals(identity.getUser()) || allowedOwners.contains(queryIdentity);
        }).collect(ImmutableList.toImmutableList());
    }

    public static void checkCanKillQueryOwnedBy(Identity identity, Identity queryOwner, AccessControl accessControl) {
        if (identity.getUser().equals(queryOwner.getUser())) {
            return;
        }
        accessControl.checkCanKillQueryOwnedBy(identity, queryOwner);
    }
}

