/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import io.airlift.slice.SizeOf;
import io.trino.operator.window.matcher.ArrayView;
import io.trino.operator.window.matcher.IntList;
import java.util.Arrays;

class IntMultimap {
    private static final long INSTANCE_SIZE = SizeOf.instanceSize(IntMultimap.class);
    private IntList[] values;
    private final int capacity;
    private final int listCapacity;
    private long valuesSize;

    public IntMultimap(int capacity, int listCapacity) {
        this.values = new IntList[capacity];
        this.capacity = capacity;
        this.listCapacity = listCapacity;
        this.valuesSize = 0L;
    }

    public void add(int key, int value) {
        long listSizeBefore;
        boolean expanded = this.ensureCapacity(key);
        if (expanded || this.values[key] == null) {
            listSizeBefore = 0L;
            this.values[key] = new IntList(this.listCapacity);
        } else {
            listSizeBefore = this.values[key].getSizeInBytes();
        }
        this.values[key].add(value);
        this.valuesSize += this.values[key].getSizeInBytes() - listSizeBefore;
    }

    public void release(int key) {
        if (this.values[key] != null) {
            this.valuesSize -= this.values[key].getSizeInBytes();
            this.values[key] = null;
        }
    }

    public void copy(int parent, int child) {
        boolean expanded = this.ensureCapacity(child);
        if (expanded || this.values[child] == null) {
            if (this.values[parent] != null) {
                this.values[child] = this.values[parent].copy();
                this.valuesSize += this.values[child].getSizeInBytes();
            }
        } else if (this.values[parent] != null) {
            long listSizeBefore = this.values[child].getSizeInBytes();
            this.values[child] = this.values[parent].copy();
            this.valuesSize += this.values[child].getSizeInBytes() - listSizeBefore;
        } else {
            this.valuesSize -= this.values[child].getSizeInBytes();
            this.values[child] = null;
        }
    }

    public ArrayView getArrayView(int key) {
        if (this.values[key] == null) {
            return ArrayView.EMPTY;
        }
        return this.values[key].toArrayView();
    }

    public void clear() {
        this.values = new IntList[this.capacity];
        this.valuesSize = 0L;
    }

    private boolean ensureCapacity(int key) {
        if (key >= this.values.length) {
            this.values = Arrays.copyOf(this.values, Math.max(this.values.length * 2, key + 1));
            return true;
        }
        return false;
    }

    public long getSizeInBytes() {
        return INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.values) + this.valuesSize;
    }
}

