/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.trino.spi.function.WindowFunction;
import io.trino.spi.function.WindowFunctionSupplier;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public class ReflectionWindowFunctionSupplier
implements WindowFunctionSupplier {
    private final int argumentCount;
    private final Constructor<? extends WindowFunction> constructor;
    private final ConstructorType constructorType;

    public ReflectionWindowFunctionSupplier(int argumentCount, Class<? extends WindowFunction> type) {
        ConstructorType constructorTypeValue;
        this.argumentCount = argumentCount;
        Constructor constructor = null;
        ConstructorType constructorType = null;
        ConstructorType[] constructorTypeArray = ConstructorType.values();
        int n = constructorTypeArray.length;
        for (int i = 0; i < n && (constructor = (Constructor)(constructorType = (constructorTypeValue = constructorTypeArray[i])).tryGetConstructor(type).orElse(null)) == null; ++i) {
        }
        Preconditions.checkArgument((constructor != null ? 1 : 0) != 0, (String)"No constructor found for type: %s", (Object)type.getName());
        this.constructor = constructor;
        this.constructorType = constructorType;
    }

    public List<Class<?>> getLambdaInterfaces() {
        return ImmutableList.of();
    }

    public WindowFunction createWindowFunction(boolean ignoreNulls, List<Supplier<Object>> lambdaProviders) {
        Objects.requireNonNull(lambdaProviders, "lambdaProviders is null");
        Preconditions.checkArgument((boolean)lambdaProviders.isEmpty(), (Object)"lambdaProviders is not empty");
        List argumentChannels = (List)IntStream.range(0, this.argumentCount).boxed().collect(ImmutableList.toImmutableList());
        try {
            switch (this.constructorType) {
                case NO_INPUTS: {
                    return this.constructor.newInstance(new Object[0]);
                }
                case IGNORE_NULLS: {
                    return this.constructor.newInstance(ignoreNulls);
                }
                case INPUTS: {
                    return this.constructor.newInstance(argumentChannels);
                }
                case INPUTS_IGNORE_NULLS: {
                    return this.constructor.newInstance(argumentChannels, ignoreNulls);
                }
            }
            throw new VerifyException("Unhandled constructor type: " + this.constructorType);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ConstructorType {
        INPUTS_IGNORE_NULLS{

            @Override
            Optional<Constructor<? extends WindowFunction>> tryGetConstructor(Class<? extends WindowFunction> type) {
                return ConstructorType.optionalConstructor(type, List.class, Boolean.TYPE);
            }
        }
        ,
        INPUTS{

            @Override
            Optional<Constructor<? extends WindowFunction>> tryGetConstructor(Class<? extends WindowFunction> type) {
                return ConstructorType.optionalConstructor(type, List.class);
            }
        }
        ,
        IGNORE_NULLS{

            @Override
            Optional<Constructor<? extends WindowFunction>> tryGetConstructor(Class<? extends WindowFunction> type) {
                return ConstructorType.optionalConstructor(type, Boolean.TYPE);
            }
        }
        ,
        NO_INPUTS{

            @Override
            Optional<Constructor<? extends WindowFunction>> tryGetConstructor(Class<? extends WindowFunction> type) {
                return ConstructorType.optionalConstructor(type, new Class[0]);
            }
        };


        abstract Optional<Constructor<? extends WindowFunction>> tryGetConstructor(Class<? extends WindowFunction> var1);

        private static Optional<Constructor<? extends WindowFunction>> optionalConstructor(Class<? extends WindowFunction> type, Class<?> ... parameterTypes) {
            try {
                return Optional.of(type.getConstructor(parameterTypes));
            }
            catch (NoSuchMethodException e) {
                return Optional.empty();
            }
        }
    }
}

