/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timetz;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimeWithTimeZone;
import io.trino.type.DateTimes;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeWithTimeZoneToVarcharCast {
    private TimeWithTimeZoneToVarcharCast() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice cast(@LiteralParameter(value="p") long precision, @SqlType(value="time(p) with time zone") long packedTime) {
        long nanos = DateTimeEncoding.unpackTimeNanos((long)packedTime);
        int offsetMinutes = DateTimeEncoding.unpackOffsetMinutes((long)packedTime);
        return TimeWithTimeZoneToVarcharCast.format((int)precision, nanos * 1000L, offsetMinutes);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice cast(@LiteralParameter(value="p") long precision, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone time) {
        return TimeWithTimeZoneToVarcharCast.format((int)precision, time.getPicoseconds(), time.getOffsetMinutes());
    }

    private static Slice format(int precision, long picos, int offsetMinutes) {
        int size = 8 + (precision > 0 ? 1 : 0) + precision + 6;
        int hours = (int)(picos / 3600000000000000L);
        int minutes = (int)(picos / 60000000000000L % 60L);
        int seconds = (int)(picos / 1000000000000L % 60L);
        int zoneOffsetHours = Math.abs(offsetMinutes / 60);
        int zoneOffsetMinutes = Math.abs(offsetMinutes % 60);
        byte[] bytes = new byte[size];
        TimeWithTimeZoneToVarcharCast.appendTwoDecimalDigits(0, bytes, hours);
        bytes[2] = 58;
        TimeWithTimeZoneToVarcharCast.appendTwoDecimalDigits(3, bytes, minutes);
        bytes[5] = 58;
        TimeWithTimeZoneToVarcharCast.appendTwoDecimalDigits(6, bytes, seconds);
        int offsetStartAt = 8;
        if (precision > 0) {
            bytes[8] = 46;
            long scaledFraction = picos % 1000000000000L / DateTimes.scaleFactor(precision, 12);
            for (int index = 8 + precision; index > 8; --index) {
                long temp = scaledFraction / 10L;
                int digit = (int)(scaledFraction - temp * 10L);
                scaledFraction = temp;
                bytes[index] = (byte)(48 + digit);
            }
            offsetStartAt += precision + 1;
        }
        bytes[offsetStartAt] = offsetMinutes >= 0 ? 43 : 45;
        TimeWithTimeZoneToVarcharCast.appendTwoDecimalDigits(offsetStartAt + 1, bytes, zoneOffsetHours);
        bytes[offsetStartAt + 3] = 58;
        TimeWithTimeZoneToVarcharCast.appendTwoDecimalDigits(offsetStartAt + 4, bytes, zoneOffsetMinutes);
        return Slices.wrappedBuffer((byte[])bytes);
    }

    private static void appendTwoDecimalDigits(int index, byte[] bytes, int value) {
        int tens = value / 10;
        int ones = value - tens * 10;
        bytes[index] = (byte)(48 + tens);
        bytes[index + 1] = (byte)(48 + ones);
    }
}

