/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.annotations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.ParametricImplementationsGroup;
import io.trino.operator.annotations.FunctionsParserHelper;
import io.trino.operator.scalar.ParametricScalar;
import io.trino.operator.scalar.annotations.OperatorValidator;
import io.trino.operator.scalar.annotations.ParametricScalarImplementation;
import io.trino.operator.scalar.annotations.ScalarImplementationHeader;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.Signature;
import io.trino.spi.function.SqlType;
import io.trino.util.Failures;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ScalarFromAnnotationsParser {
    private ScalarFromAnnotationsParser() {
    }

    public static List<SqlScalarFunction> parseFunctionDefinition(Class<?> clazz) {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean deprecated = ((Deprecated[])clazz.getAnnotationsByType(Deprecated.class)).length > 0;
        for (ScalarHeaderAndMethods scalar : ScalarFromAnnotationsParser.findScalarsInFunctionDefinitionClass(clazz)) {
            builder.add((Object)ScalarFromAnnotationsParser.parseParametricScalar(scalar, FunctionsParserHelper.findConstructor(clazz), deprecated));
        }
        return builder.build();
    }

    public static List<SqlScalarFunction> parseFunctionDefinitions(Class<?> clazz) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ScalarHeaderAndMethods methods : ScalarFromAnnotationsParser.findScalarsInFunctionSetClass(clazz)) {
            boolean deprecated = ((Deprecated[])methods.getMethods().iterator().next().getAnnotationsByType(Deprecated.class)).length > 0;
            builder.add((Object)ScalarFromAnnotationsParser.parseParametricScalar(methods, FunctionsParserHelper.findConstructor(clazz), deprecated));
        }
        return builder.build();
    }

    private static List<ScalarHeaderAndMethods> findScalarsInFunctionDefinitionClass(Class<?> annotated) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<ScalarImplementationHeader> classHeaders = ScalarImplementationHeader.fromAnnotatedElement(annotated);
        Preconditions.checkArgument((!classHeaders.isEmpty() ? 1 : 0) != 0, (String)"Class [%s] that defines function must be annotated with @ScalarFunction or @ScalarOperator", (Object)annotated.getName());
        for (ScalarImplementationHeader header : classHeaders) {
            Set<Method> methods = FunctionsParserHelper.findPublicMethodsWithAnnotation(annotated, SqlType.class, ScalarFunction.class, ScalarOperator.class);
            Failures.checkCondition(!methods.isEmpty(), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Parametric class [%s] does not have any annotated methods", annotated.getName());
            for (Method method : methods) {
                Preconditions.checkArgument((method.getAnnotation(ScalarFunction.class) == null ? 1 : 0) != 0, (String)"Parametric class method [%s] is annotated with @ScalarFunction", (Object)method);
                Preconditions.checkArgument((method.getAnnotation(ScalarOperator.class) == null ? 1 : 0) != 0, (String)"Parametric class method [%s] is annotated with @ScalarOperator", (Object)method);
            }
            builder.add((Object)new ScalarHeaderAndMethods(header, methods));
        }
        return builder.build();
    }

    private static List<ScalarHeaderAndMethods> findScalarsInFunctionSetClass(Class<?> annotated) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Method method : FunctionsParserHelper.findPublicMethodsWithAnnotation(annotated, SqlType.class, ScalarFunction.class, ScalarOperator.class)) {
            Failures.checkCondition(method.getAnnotation(ScalarFunction.class) != null || method.getAnnotation(ScalarOperator.class) != null, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Method [%s] annotated with @SqlType is missing @ScalarFunction or @ScalarOperator", method);
            for (ScalarImplementationHeader header : ScalarImplementationHeader.fromAnnotatedElement(method)) {
                builder.add((Object)new ScalarHeaderAndMethods(header, (Set<Method>)ImmutableSet.of((Object)method)));
            }
        }
        ImmutableList methods = builder.build();
        Preconditions.checkArgument((!methods.isEmpty() ? 1 : 0) != 0, (String)"Class [%s] does not have any methods annotated with @ScalarFunction or @ScalarOperator", (Object)annotated.getName());
        return methods;
    }

    private static SqlScalarFunction parseParametricScalar(ScalarHeaderAndMethods scalar, Optional<Constructor<?>> constructor, boolean deprecated) {
        ScalarImplementationHeader header = scalar.getHeader();
        Preconditions.checkArgument((!header.getName().isEmpty() ? 1 : 0) != 0);
        HashMap<ParametricScalarImplementation.SpecializedSignature, ParametricScalarImplementation.Builder> signatures = new HashMap<ParametricScalarImplementation.SpecializedSignature, ParametricScalarImplementation.Builder>();
        for (Method method : scalar.getMethods()) {
            ParametricScalarImplementation.Builder builder;
            Object implementation = new ParametricScalarImplementation.Parser(header.getName(), method, constructor);
            if (!signatures.containsKey(((ParametricScalarImplementation.Parser)implementation).getSpecializedSignature())) {
                builder = new ParametricScalarImplementation.Builder(((ParametricScalarImplementation.Parser)implementation).getSignature(), ((ParametricScalarImplementation.Parser)implementation).getArgumentNativeContainerTypes(), ((ParametricScalarImplementation.Parser)implementation).getSpecializedTypeParameters(), ((ParametricScalarImplementation.Parser)implementation).getReturnNativeContainerType());
                signatures.put(((ParametricScalarImplementation.Parser)implementation).getSpecializedSignature(), builder);
                builder.addChoice(((ParametricScalarImplementation.Parser)implementation).getChoice());
                continue;
            }
            builder = (ParametricScalarImplementation.Builder)signatures.get(((ParametricScalarImplementation.Parser)implementation).getSpecializedSignature());
            builder.addChoice(((ParametricScalarImplementation.Parser)implementation).getChoice());
        }
        ParametricImplementationsGroup.Builder<ParametricScalarImplementation> implementationsBuilder = ParametricImplementationsGroup.builder();
        for (Object implementation : signatures.values()) {
            implementationsBuilder.addImplementation(((ParametricScalarImplementation.Builder)implementation).build());
        }
        ParametricImplementationsGroup<ParametricScalarImplementation> parametricImplementationsGroup = implementationsBuilder.build();
        Signature scalarSignature = parametricImplementationsGroup.getSignature();
        header.getOperatorType().ifPresent(operatorType -> OperatorValidator.validateOperator(operatorType, scalarSignature.getReturnType(), scalarSignature.getArgumentTypes()));
        return new ParametricScalar(scalarSignature, header.getHeader(), parametricImplementationsGroup, deprecated);
    }

    private static class ScalarHeaderAndMethods {
        private final ScalarImplementationHeader header;
        private final Set<Method> methods;

        public ScalarHeaderAndMethods(ScalarImplementationHeader header, Set<Method> methods) {
            this.header = Objects.requireNonNull(header);
            this.methods = Objects.requireNonNull(methods);
        }

        public ScalarImplementationHeader getHeader() {
            return this.header;
        }

        public Set<Method> getMethods() {
            return this.methods;
        }
    }
}

