/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Verify;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BufferedArrayValueBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;

@ScalarFunction(value="map_entries")
@Description(value="Construct an array of entries from a given map")
public class MapEntriesFunction {
    private final BufferedArrayValueBuilder arrayValueBuilder;

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    public MapEntriesFunction(@TypeParameter(value="array(row(K,V))") Type arrayType) {
        this.arrayValueBuilder = BufferedArrayValueBuilder.createBuffered((ArrayType)((ArrayType)arrayType));
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="array(row(K,V))")
    public Block mapFromEntries(@TypeParameter(value="row(K,V)") RowType rowType, @SqlType(value="map(K,V)") Block block) {
        Verify.verify((rowType.getTypeParameters().size() == 2 ? 1 : 0) != 0);
        Verify.verify((block.getPositionCount() % 2 == 0 ? 1 : 0) != 0);
        Type keyType = (Type)rowType.getTypeParameters().get(0);
        Type valueType = (Type)rowType.getTypeParameters().get(1);
        int entryCount = block.getPositionCount() / 2;
        return this.arrayValueBuilder.build(entryCount, valueBuilder -> {
            for (int i = 0; i < entryCount; ++i) {
                int position = 2 * i;
                ((RowBlockBuilder)valueBuilder).buildEntry(fieldBuilders -> {
                    keyType.appendTo(block, position, (BlockBuilder)fieldBuilders.get(0));
                    valueType.appendTo(block, position + 1, (BlockBuilder)fieldBuilders.get(1));
                });
            }
        });
    }
}

