/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedArrayValueBuilder;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;

@ScalarFunction(value="reverse")
@Description(value="Returns an array which has the reversed order of the given array.")
public final class ArrayReverseFunction {
    private final BufferedArrayValueBuilder arrayValueBuilder;

    @TypeParameter(value="E")
    public ArrayReverseFunction(@TypeParameter(value="E") Type elementType) {
        this.arrayValueBuilder = BufferedArrayValueBuilder.createBuffered((ArrayType)new ArrayType(elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block reverse(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block block) {
        int arrayLength = block.getPositionCount();
        if (arrayLength < 2) {
            return block;
        }
        return this.arrayValueBuilder.build(arrayLength, elementBuilder -> {
            for (int i = arrayLength - 1; i >= 0; --i) {
                type.appendTo(block, i, elementBuilder);
            }
        });
    }
}

