/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedArrayValueBuilder;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.gen.VarArgsToArrayAdapterGenerator;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.Optional;

public final class ArrayConcatFunction
extends SqlScalarFunction {
    public static final ArrayConcatFunction ARRAY_CONCAT_FUNCTION = new ArrayConcatFunction();
    private static final String FUNCTION_NAME = "concat";
    private static final String DESCRIPTION = "Concatenates given arrays";
    private static final MethodHandle METHOD_HANDLE;
    private static final MethodHandle USER_STATE_FACTORY;

    private ArrayConcatFunction() {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name(FUNCTION_NAME).typeVariable("E").returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).variableArity().build()).description(DESCRIPTION).build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        if (boundSignature.getArity() < 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "There must be two or more arguments to concat");
        }
        ArrayType arrayType = (ArrayType)boundSignature.getReturnType();
        VarArgsToArrayAdapterGenerator.MethodHandleAndConstructor methodHandleAndConstructor = VarArgsToArrayAdapterGenerator.generateVarArgsToArrayAdapter(Block.class, Block.class, boundSignature.getArity(), METHOD_HANDLE.bindTo(arrayType.getElementType()), USER_STATE_FACTORY.bindTo(arrayType));
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, Collections.nCopies(boundSignature.getArity(), InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandleAndConstructor.getMethodHandle(), Optional.of(methodHandleAndConstructor.getConstructor()));
    }

    @UsedByGeneratedCode
    public static Object createState(ArrayType arrayType) {
        return BufferedArrayValueBuilder.createBuffered((ArrayType)arrayType);
    }

    @UsedByGeneratedCode
    public static Block concat(Type elementType, Object state, Block[] blocks) {
        int resultPositionCount = 0;
        Block nonEmptyBlock = null;
        for (Block value : blocks) {
            resultPositionCount += value.getPositionCount();
            if (value.getPositionCount() <= 0) continue;
            nonEmptyBlock = value;
        }
        if (nonEmptyBlock == null) {
            return blocks[0];
        }
        if (resultPositionCount == nonEmptyBlock.getPositionCount()) {
            return nonEmptyBlock;
        }
        return ((BufferedArrayValueBuilder)state).build(resultPositionCount, elementBuilder -> {
            for (Block block : blocks) {
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    elementType.appendTo(block, i, elementBuilder);
                }
            }
        });
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            METHOD_HANDLE = lookup.findStatic(ArrayConcatFunction.class, FUNCTION_NAME, MethodType.methodType(Block.class, Type.class, Object.class, Block[].class));
            USER_STATE_FACTORY = lookup.findStatic(ArrayConcatFunction.class, "createState", MethodType.methodType(Object.class, ArrayType.class));
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

