/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import io.trino.plugin.base.metrics.DurationTiming;
import io.trino.spi.metrics.Metrics;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class PageProcessorMetrics {
    private static final String FILTER_TIME = "Filter CPU time";
    private static final String PROJECTION_TIME = "Projection CPU time";
    private long filterTimeNanos;
    private boolean hasFilter;
    private long projectionTimeNanos;
    private boolean hasProjection;

    public void recordFilterTimeSince(long startNanos) {
        this.filterTimeNanos += System.nanoTime() - startNanos;
        this.hasFilter = true;
    }

    public void recordProjectionTime(long projectionTimeNanos) {
        this.projectionTimeNanos += projectionTimeNanos;
        this.hasProjection = true;
    }

    public Metrics getMetrics() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.hasFilter) {
            builder.put((Object)FILTER_TIME, (Object)new DurationTiming(new Duration((double)this.filterTimeNanos, TimeUnit.NANOSECONDS)));
        }
        if (this.hasProjection) {
            builder.put((Object)PROJECTION_TIME, (Object)new DurationTiming(new Duration((double)this.projectionTimeNanos, TimeUnit.NANOSECONDS)));
        }
        return new Metrics((Map)builder.buildOrThrow());
    }
}

