/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join.unspilled;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.trino.operator.join.LookupSource;
import io.trino.operator.join.unspilled.JoinProbe;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.Type;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Objects;

public class LookupJoinPageBuilder {
    private final IntArrayList probeIndexBuilder = new IntArrayList();
    private final PageBuilder buildPageBuilder;
    private final int buildOutputChannelCount;
    private long estimatedProbeBlockBytes;
    private long estimatedProbeRowSize = -1L;
    private int previousPosition = -1;
    private boolean isSequentialProbeIndices = true;
    private boolean repeatBuildRow;

    public LookupJoinPageBuilder(List<Type> buildTypes) {
        this.buildPageBuilder = new PageBuilder(Objects.requireNonNull(buildTypes, "buildTypes is null"));
        this.buildOutputChannelCount = buildTypes.size();
    }

    public boolean isFull() {
        return this.estimatedProbeBlockBytes + this.buildPageBuilder.getSizeInBytes() >= 0x100000L || this.buildPageBuilder.getPositionCount() >= 8192 || this.buildPageBuilder.isFull();
    }

    public boolean isEmpty() {
        return this.probeIndexBuilder.isEmpty() && this.buildPageBuilder.isEmpty();
    }

    public int getPositionCount() {
        Verify.verify((!this.repeatBuildRow ? 1 : 0) != 0);
        return this.probeIndexBuilder.size();
    }

    public void reset() {
        this.probeIndexBuilder.clear();
        this.buildPageBuilder.reset();
        this.estimatedProbeBlockBytes = 0L;
        this.estimatedProbeRowSize = -1L;
        this.previousPosition = -1;
        this.isSequentialProbeIndices = true;
        this.repeatBuildRow = false;
    }

    public void appendRow(JoinProbe probe, LookupSource lookupSource, long joinPosition) {
        this.appendProbeIndex(probe);
        this.buildPageBuilder.declarePosition();
        lookupSource.appendTo(joinPosition, this.buildPageBuilder, 0);
    }

    public void appendNullForBuild(JoinProbe probe) {
        this.appendProbeIndex(probe);
        this.buildPageBuilder.declarePosition();
        for (int i = 0; i < this.buildOutputChannelCount; ++i) {
            this.buildPageBuilder.getBlockBuilder(i).appendNull();
        }
    }

    public void repeatBuildRow() {
        this.repeatBuildRow = true;
    }

    public Page build(JoinProbe probe) {
        int i;
        if (this.repeatBuildRow) {
            return this.buildRepeatedPage(probe);
        }
        int outputPositions = this.probeIndexBuilder.size();
        Verify.verify((this.buildPageBuilder.getPositionCount() == outputPositions ? 1 : 0) != 0);
        int[] probeOutputChannels = probe.getOutputChannels();
        Block[] blocks = new Block[probeOutputChannels.length + this.buildOutputChannelCount];
        Page probePage = probe.getPage();
        if (!this.isSequentialProbeIndices || outputPositions == 0) {
            int[] probeIndices = this.probeIndexBuilder.toIntArray();
            for (i = 0; i < probeOutputChannels.length; ++i) {
                blocks[i] = LookupJoinPageBuilder.unwrapLoadedBlock(probePage.getBlock(probeOutputChannels[i]).getPositions(probeIndices, 0, outputPositions));
            }
        } else {
            int startRegion = this.probeIndexBuilder.getInt(0);
            Verify.verify((this.previousPosition - startRegion == outputPositions - 1 ? 1 : 0) != 0);
            boolean outputProbeBlocksDirectly = startRegion == 0 && outputPositions == probePage.getPositionCount();
            for (int i2 = 0; i2 < probeOutputChannels.length; ++i2) {
                Block block = probePage.getBlock(probeOutputChannels[i2]);
                if (!outputProbeBlocksDirectly) {
                    block = block.getRegion(startRegion, outputPositions);
                }
                blocks[i2] = LookupJoinPageBuilder.unwrapLoadedBlock(block);
            }
        }
        int offset = probeOutputChannels.length;
        for (i = 0; i < this.buildOutputChannelCount; ++i) {
            blocks[offset + i] = this.buildPageBuilder.getBlockBuilder(i).build();
            Verify.verify((blocks[offset + i].getPositionCount() == outputPositions ? 1 : 0) != 0);
        }
        return new Page(outputPositions, blocks);
    }

    private Page buildRepeatedPage(JoinProbe probe) {
        Verify.verify((boolean)probe.areProbeJoinChannelsRunLengthEncoded());
        Verify.verify((this.buildPageBuilder.getPositionCount() == 1 ? 1 : 0) != 0);
        Verify.verify((this.probeIndexBuilder.size() == 1 ? 1 : 0) != 0);
        Verify.verify((this.probeIndexBuilder.getInt(0) == 0 ? 1 : 0) != 0);
        int positionCount = probe.getPage().getPositionCount();
        int[] probeOutputChannels = probe.getOutputChannels();
        Block[] blocks = new Block[probeOutputChannels.length + this.buildOutputChannelCount];
        for (int i = 0; i < probeOutputChannels.length; ++i) {
            blocks[i] = probe.getPage().getBlock(probeOutputChannels[i]);
        }
        int offset = probeOutputChannels.length;
        for (int i = 0; i < this.buildOutputChannelCount; ++i) {
            Block buildBlock = this.buildPageBuilder.getBlockBuilder(i).build();
            blocks[offset + i] = RunLengthEncodedBlock.create((Block)buildBlock, (int)positionCount);
        }
        return new Page(positionCount, blocks);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("estimatedSize", this.estimatedProbeBlockBytes + this.buildPageBuilder.getSizeInBytes()).add("positionCount", this.buildPageBuilder.getPositionCount()).toString();
    }

    private static Block unwrapLoadedBlock(Block filteredProbeBlock) {
        return filteredProbeBlock.isLoaded() ? filteredProbeBlock.getLoadedBlock() : filteredProbeBlock;
    }

    private void appendProbeIndex(JoinProbe probe) {
        int position = probe.getPosition();
        Verify.verify((position >= 0 && this.previousPosition <= position ? 1 : 0) != 0);
        this.isSequentialProbeIndices &= position == this.previousPosition + 1 || this.previousPosition == -1;
        this.probeIndexBuilder.add(position);
        this.estimatedProbeBlockBytes += 4L;
        if (this.previousPosition != position) {
            this.previousPosition = position;
            this.estimatedProbeBlockBytes += this.getEstimatedProbeRowSize(probe);
        }
    }

    private long getEstimatedProbeRowSize(JoinProbe probe) {
        if (this.estimatedProbeRowSize != -1L) {
            return this.estimatedProbeRowSize;
        }
        long estimatedProbeRowSize = 0L;
        for (int index : probe.getOutputChannels()) {
            Block block = probe.getPage().getBlock(index);
            estimatedProbeRowSize += block.getSizeInBytes() / (long)block.getPositionCount();
        }
        this.estimatedProbeRowSize = estimatedProbeRowSize;
        return estimatedProbeRowSize;
    }
}

