/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.annotation.NotThreadSafe;
import io.trino.operator.join.LookupSource;
import io.trino.operator.join.LookupSourceFactory;
import io.trino.operator.join.LookupSourceProvider;
import io.trino.operator.join.OuterLookupSource;
import io.trino.operator.join.OuterPositionIterator;
import io.trino.operator.join.PartitionedConsumption;
import io.trino.operator.join.PartitionedLookupSource;
import io.trino.operator.join.SpilledLookupSourceHandle;
import io.trino.operator.join.TrackingLookupSourceSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Supplier;

public final class PartitionedLookupSourceFactory
implements LookupSourceFactory {
    public static final long NO_SPILL_EPOCH = 0L;
    private final List<Type> types;
    private final List<Type> outputTypes;
    private final List<Type> hashChannelTypes;
    private final boolean outer;
    private final SpilledLookupSource spilledLookupSource;
    private final BlockTypeOperators blockTypeOperators;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    private final Supplier<LookupSource>[] partitions;
    private final SettableFuture<Void> partitionsNoLongerNeeded = SettableFuture.create();
    @GuardedBy(value="lock")
    private final SettableFuture<Void> destroyed = SettableFuture.create();
    @GuardedBy(value="lock")
    private int partitionsSet;
    @GuardedBy(value="lock")
    private SpillingInfo spillingInfo = new SpillingInfo(0L, (Set<Integer>)ImmutableSet.of());
    @GuardedBy(value="lock")
    private final Map<Integer, SpilledLookupSourceHandle> spilledPartitions = new HashMap<Integer, SpilledLookupSourceHandle>();
    @GuardedBy(value="lock")
    private TrackingLookupSourceSupplier lookupSourceSupplier;
    @GuardedBy(value="lock")
    private final List<SettableFuture<LookupSourceProvider>> lookupSourceFutures = new ArrayList<SettableFuture<LookupSourceProvider>>();
    @GuardedBy(value="lock")
    private int finishedProbeOperators;
    @GuardedBy(value="lock")
    private OptionalInt partitionedConsumptionParticipants = OptionalInt.empty();
    @GuardedBy(value="lock")
    private final SettableFuture<PartitionedConsumption<Supplier<LookupSource>>> partitionedConsumption = SettableFuture.create();
    private final ConcurrentHashMap<SpillAwareLookupSourceProvider, LookupSource> suppliedLookupSources = new ConcurrentHashMap();

    public PartitionedLookupSourceFactory(List<Type> types, List<Type> outputTypes, List<Type> hashChannelTypes, int partitionCount, boolean outer, BlockTypeOperators blockTypeOperators) {
        Preconditions.checkArgument((Integer.bitCount(partitionCount) == 1 ? 1 : 0) != 0, (Object)"partitionCount must be a power of 2");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.outputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputTypes, "outputTypes is null"));
        this.hashChannelTypes = ImmutableList.copyOf(hashChannelTypes);
        Preconditions.checkArgument((partitionCount > 0 ? 1 : 0) != 0);
        this.partitions = new Supplier[partitionCount];
        this.outer = outer;
        this.spilledLookupSource = new SpilledLookupSource();
        this.blockTypeOperators = blockTypeOperators;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    @Override
    public int partitions() {
        return this.partitions.length;
    }

    @Override
    public ListenableFuture<LookupSourceProvider> createLookupSourceProvider() {
        this.lock.writeLock().lock();
        try {
            Preconditions.checkState((!this.destroyed.isDone() ? 1 : 0) != 0, (Object)"already destroyed");
            if (this.lookupSourceSupplier != null) {
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)new SpillAwareLookupSourceProvider());
                return listenableFuture;
            }
            SettableFuture lookupSourceFuture = SettableFuture.create();
            this.lookupSourceFutures.add((SettableFuture<LookupSourceProvider>)lookupSourceFuture);
            SettableFuture settableFuture = lookupSourceFuture;
            return settableFuture;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ListenableFuture<Void> whenBuildFinishes() {
        return Futures.transform(this.createLookupSourceProvider(), lookupSourceProvider -> {
            lookupSourceProvider.close();
            return null;
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> lendPartitionLookupSource(int partitionIndex, Supplier<LookupSource> partitionLookupSource) {
        boolean completed;
        Objects.requireNonNull(partitionLookupSource, "partitionLookupSource is null");
        this.lock.writeLock().lock();
        try {
            if (this.destroyed.isDone()) {
                ListenableFuture listenableFuture = Futures.immediateVoidFuture();
                return listenableFuture;
            }
            Preconditions.checkState((this.partitions[partitionIndex] == null ? 1 : 0) != 0, (Object)"Partition already set");
            Preconditions.checkState((!this.spilledPartitions.containsKey(partitionIndex) ? 1 : 0) != 0, (Object)"Partition already set as spilled");
            this.partitions[partitionIndex] = partitionLookupSource;
            ++this.partitionsSet;
            completed = this.partitionsSet == this.partitions.length;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (completed) {
            this.supplyLookupSources();
        }
        return this.partitionsNoLongerNeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPartitionSpilledLookupSourceHandle(int partitionIndex, SpilledLookupSourceHandle spilledLookupSourceHandle) {
        boolean completed;
        Objects.requireNonNull(spilledLookupSourceHandle, "spilledLookupSourceHandle is null");
        this.lock.writeLock().lock();
        try {
            if (this.partitionsNoLongerNeeded.isDone()) {
                spilledLookupSourceHandle.dispose();
                return;
            }
            Preconditions.checkState((!this.spilledPartitions.containsKey(partitionIndex) ? 1 : 0) != 0, (Object)"Partition already set as spilled");
            this.spilledPartitions.put(partitionIndex, spilledLookupSourceHandle);
            this.spillingInfo = new SpillingInfo(this.spillingInfo.spillEpoch() + 1L, this.spilledPartitions.keySet());
            if (this.partitions[partitionIndex] != null) {
                completed = false;
            } else {
                ++this.partitionsSet;
                completed = this.partitionsSet == this.partitions.length;
            }
            this.partitions[partitionIndex] = () -> this.spilledLookupSource;
            if (this.lookupSourceSupplier != null) {
                Verify.verify((!completed ? 1 : 0) != 0, (String)"lookupSourceSupplier already exist when completing", (Object[])new Object[0]);
                Verify.verify((!this.outer ? 1 : 0) != 0, (String)"It is not possible to reset lookupSourceSupplier which is tracking for outer join", (Object[])new Object[0]);
                Verify.verify((this.partitions.length > 1 ? 1 : 0) != 0, (String)"Spill occurred when only one partition", (Object[])new Object[0]);
                this.lookupSourceSupplier = PartitionedLookupSource.createPartitionedLookupSourceSupplier((List<Supplier<LookupSource>>)ImmutableList.copyOf((Object[])this.partitions), this.hashChannelTypes, this.outer, this.blockTypeOperators);
                this.closeCachedLookupSources();
            } else {
                Verify.verify((boolean)this.suppliedLookupSources.isEmpty(), (String)"There are cached LookupSources even though lookupSourceSupplier does not exist", (Object[])new Object[0]);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (completed) {
            this.supplyLookupSources();
        }
    }

    private void supplyLookupSources() {
        ImmutableList lookupSourceFutures;
        Preconditions.checkState((!this.lock.isWriteLockedByCurrentThread() ? 1 : 0) != 0);
        this.lock.writeLock().lock();
        try {
            Preconditions.checkState((this.partitionsSet == this.partitions.length ? 1 : 0) != 0, (Object)"Not all set yet");
            Preconditions.checkState((this.lookupSourceSupplier == null ? 1 : 0) != 0, (Object)"Already supplied");
            if (this.partitionsNoLongerNeeded.isDone()) {
                return;
            }
            if (this.partitionsSet != 1) {
                ImmutableList partitions = ImmutableList.copyOf((Object[])this.partitions);
                this.lookupSourceSupplier = PartitionedLookupSource.createPartitionedLookupSourceSupplier((List<Supplier<LookupSource>>)partitions, this.hashChannelTypes, this.outer, this.blockTypeOperators);
            } else if (this.outer) {
                this.lookupSourceSupplier = OuterLookupSource.createOuterLookupSourceSupplier(this.partitions[0]);
            } else {
                Preconditions.checkState((!this.spillingInfo.hasSpilled() ? 1 : 0) != 0, (Object)"Spill not supported when there is single partition");
                this.lookupSourceSupplier = TrackingLookupSourceSupplier.nonTracking(this.partitions[0]);
            }
            lookupSourceFutures = ImmutableList.copyOf(this.lookupSourceFutures);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (SettableFuture lookupSourceFuture : lookupSourceFutures) {
            lookupSourceFuture.set((Object)new SpillAwareLookupSourceProvider());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<PartitionedConsumption<Supplier<LookupSource>>> finishProbeOperator(OptionalInt lookupJoinsCount) {
        this.lock.writeLock().lock();
        try {
            if (!this.spillingInfo.hasSpilled()) {
                ++this.finishedProbeOperators;
                if (lookupJoinsCount.isPresent()) {
                    Preconditions.checkState((this.finishedProbeOperators <= lookupJoinsCount.getAsInt() ? 1 : 0) != 0, (String)"%s probe operators finished out of %s declared", (int)this.finishedProbeOperators, (int)lookupJoinsCount.getAsInt());
                    if (this.finishedProbeOperators == lookupJoinsCount.getAsInt()) {
                        this.freePartitions();
                    }
                }
                ListenableFuture listenableFuture = Futures.immediateFuture(new PartitionedConsumption(1, Collections.emptyList(), i -> {
                    throw new UnsupportedOperationException();
                }, i -> {}, i -> {
                    throw new UnsupportedOperationException();
                }));
                return listenableFuture;
            }
            int operatorsCount = lookupJoinsCount.orElseThrow(() -> new IllegalStateException("A fixed distribution is required for JOIN when spilling is enabled"));
            Preconditions.checkState((this.finishedProbeOperators < operatorsCount ? 1 : 0) != 0, (String)"%s probe operators finished out of %s declared", (int)(this.finishedProbeOperators + 1), (int)operatorsCount);
            if (this.partitionedConsumptionParticipants.isEmpty()) {
                this.partitionedConsumptionParticipants = OptionalInt.of(operatorsCount - this.finishedProbeOperators);
            }
            ++this.finishedProbeOperators;
            if (this.finishedProbeOperators == operatorsCount) {
                this.freePartitions();
                Verify.verify((!this.partitionedConsumption.isDone() ? 1 : 0) != 0);
                this.partitionedConsumption.set(new PartitionedConsumption(this.partitionedConsumptionParticipants.getAsInt(), this.spilledPartitions.keySet(), this::loadSpilledLookupSource, this::disposeSpilledLookupSource, this::spilledLookupSourceDisposed));
            }
            SettableFuture<PartitionedConsumption<Supplier<LookupSource>>> settableFuture = this.partitionedConsumption;
            return settableFuture;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private ListenableFuture<Supplier<LookupSource>> loadSpilledLookupSource(int partitionNumber) {
        return this.getSpilledLookupSourceHandle(partitionNumber).getLookupSource();
    }

    private void disposeSpilledLookupSource(int partitionNumber) {
        this.getSpilledLookupSourceHandle(partitionNumber).dispose();
    }

    private ListenableFuture<Void> spilledLookupSourceDisposed(int partitionNumber) {
        return this.getSpilledLookupSourceHandle(partitionNumber).getDisposeCompleted();
    }

    private SpilledLookupSourceHandle getSpilledLookupSourceHandle(int partitionNumber) {
        this.lock.readLock().lock();
        try {
            SpilledLookupSourceHandle spilledLookupSourceHandle = Objects.requireNonNull(this.spilledPartitions.get(partitionNumber), "spilledPartitions.get(partitionNumber) is null");
            return spilledLookupSourceHandle;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public OuterPositionIterator getOuterPositionIterator() {
        TrackingLookupSourceSupplier lookupSourceSupplier;
        this.lock.writeLock().lock();
        try {
            Preconditions.checkState((this.lookupSourceSupplier != null ? 1 : 0) != 0, (Object)"lookup source not ready yet");
            lookupSourceSupplier = this.lookupSourceSupplier;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return lookupSourceSupplier.getOuterPositionIterator();
    }

    @Override
    public void destroy() {
        this.lock.writeLock().lock();
        try {
            this.freePartitions();
            this.spilledPartitions.values().forEach(SpilledLookupSourceHandle::dispose);
            this.destroyed.set(null);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void freePartitions() {
        this.partitionsNoLongerNeeded.set(null);
        this.lock.writeLock().lock();
        try {
            Arrays.fill(this.partitions, null);
            this.lookupSourceSupplier = null;
            this.closeCachedLookupSources();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void closeCachedLookupSources() {
        this.lock.writeLock().lock();
        try {
            this.suppliedLookupSources.values().forEach(LookupSource::close);
            this.suppliedLookupSources.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ListenableFuture<Void> isDestroyed() {
        return Futures.nonCancellationPropagating(this.destroyed);
    }

    @Immutable
    private static final class SpillingInfo {
        private final long spillEpoch;
        private final Set<Integer> spilledPartitions;

        SpillingInfo(long spillEpoch, Set<Integer> spilledPartitions) {
            this.spillEpoch = spillEpoch;
            this.spilledPartitions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(spilledPartitions, "spilledPartitions is null"));
        }

        boolean hasSpilled() {
            return !this.spilledPartitions.isEmpty();
        }

        long spillEpoch() {
            return this.spillEpoch;
        }

        IntPredicate getSpillMask() {
            return this.spilledPartitions::contains;
        }
    }

    private static class SpilledLookupSource
    implements LookupSource {
        private SpilledLookupSource() {
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public long getInMemorySizeInBytes() {
            return 0L;
        }

        @Override
        public long joinPositionWithinPartition(long joinPosition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getJoinPositionCount() {
            return 0L;
        }

        @Override
        public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage, long rawHash) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getJoinPosition(int position, Page hashChannelsPage, Page allChannelsPage) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getNextJoinPosition(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isJoinPositionEligible(long currentJoinPosition, int probePosition, Page allProbeChannelsPage) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }

    @NotThreadSafe
    private class SpillAwareLookupSourceProvider
    implements LookupSourceProvider {
        private SpillAwareLookupSourceProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <R> R withLease(Function<LookupSourceProvider.LookupSourceLease, R> action) {
            PartitionedLookupSourceFactory.this.lock.readLock().lock();
            try {
                LookupSource lookupSource = PartitionedLookupSourceFactory.this.suppliedLookupSources.computeIfAbsent(this, k -> PartitionedLookupSourceFactory.this.lookupSourceSupplier.getLookupSource());
                SpillAwareLookupSourceLease lease = new SpillAwareLookupSourceLease(lookupSource, PartitionedLookupSourceFactory.this.spillingInfo);
                R r = action.apply(lease);
                return r;
            }
            finally {
                PartitionedLookupSourceFactory.this.lock.readLock().unlock();
            }
        }

        @Override
        public void close() {
            LookupSource lookupSource;
            PartitionedLookupSourceFactory.this.lock.readLock().lock();
            try {
                lookupSource = PartitionedLookupSourceFactory.this.suppliedLookupSources.remove(this);
            }
            finally {
                PartitionedLookupSourceFactory.this.lock.readLock().unlock();
            }
            if (lookupSource != null) {
                lookupSource.close();
            }
        }
    }

    private static class SpillAwareLookupSourceLease
    implements LookupSourceProvider.LookupSourceLease {
        private final LookupSource lookupSource;
        private final SpillingInfo spillingInfo;

        public SpillAwareLookupSourceLease(LookupSource lookupSource, SpillingInfo spillingInfo) {
            this.lookupSource = Objects.requireNonNull(lookupSource, "lookupSource is null");
            this.spillingInfo = Objects.requireNonNull(spillingInfo, "spillingInfo is null");
        }

        @Override
        public LookupSource getLookupSource() {
            return this.lookupSource;
        }

        @Override
        public long spillEpoch() {
            return this.spillingInfo.spillEpoch();
        }

        @Override
        public IntPredicate getSpillMask() {
            return this.spillingInfo.getSpillMask();
        }
    }
}

