/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import io.trino.operator.HashArraySizeSupplier;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.SyntheticAddress;
import io.trino.operator.join.PagesHash;
import io.trino.operator.join.PositionLinks;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class BigintPagesHash
implements PagesHash {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(BigintPagesHash.class);
    private static final DataSize CACHE_SIZE = DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private final LongArrayList addresses;
    private final List<Block> joinChannelBlocks;
    private final PagesHashStrategy pagesHashStrategy;
    private final int mask;
    private final int[] keys;
    private final long[] values;
    private final long size;

    public BigintPagesHash(LongArrayList addresses, PagesHashStrategy pagesHashStrategy, PositionLinks.FactoryBuilder positionLinks, HashArraySizeSupplier hashArraySizeSupplier, List<Page> pages, int joinChannel) {
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.pagesHashStrategy = Objects.requireNonNull(pagesHashStrategy, "pagesHashStrategy is null");
        Objects.requireNonNull(pages, "pages is null");
        ImmutableList.Builder joinChannelBlocksBuilder = ImmutableList.builder();
        for (Page page : pages) {
            joinChannelBlocksBuilder.add((Object)page.getBlock(joinChannel));
        }
        this.joinChannelBlocks = joinChannelBlocksBuilder.build();
        int hashSize = hashArraySizeSupplier.getHashArraySize(addresses.size());
        this.mask = hashSize - 1;
        this.keys = new int[hashSize];
        this.values = new long[addresses.size()];
        Arrays.fill(this.keys, -1);
        int positionsInStep = Math.min(addresses.size() + 1, (int)CACHE_SIZE.toBytes() / 32);
        int step = 0;
        while (step * positionsInStep <= addresses.size()) {
            int stepBeginPosition = step * positionsInStep;
            int stepEndPosition = Math.min((step + 1) * positionsInStep, addresses.size());
            int stepSize = stepEndPosition - stepBeginPosition;
            this.indexPages(addresses, positionLinks, stepBeginPosition, stepSize);
            ++step;
        }
        this.size = SizeOf.sizeOf((long[])addresses.elements()) + pagesHashStrategy.getSizeInBytes() + SizeOf.sizeOf((int[])this.keys) + SizeOf.sizeOf((long[])this.values);
    }

    private void indexPages(LongArrayList addresses, PositionLinks.FactoryBuilder positionLinks, int stepBeginPosition, int stepSize) {
        for (int batchIndex = 0; batchIndex < stepSize; ++batchIndex) {
            int addressIndex = batchIndex + stepBeginPosition;
            if (this.isPositionNull(addressIndex)) continue;
            long address = addresses.getLong(addressIndex);
            int blockIndex = SyntheticAddress.decodeSliceIndex(address);
            int blockPosition = SyntheticAddress.decodePosition(address);
            long value = this.joinChannelBlocks.get(blockIndex).getLong(blockPosition, 0);
            int pos = PagesHash.getHashPosition(value, this.mask);
            this.insertValue(positionLinks, addressIndex, value, pos);
        }
    }

    private void insertValue(PositionLinks.FactoryBuilder positionLinks, int addressIndex, long value, int pos) {
        while (this.keys[pos] != -1) {
            int currentKey = this.keys[pos];
            if (value == this.values[currentKey]) {
                addressIndex = positionLinks.link(addressIndex, currentKey);
                break;
            }
            pos = pos + 1 & this.mask;
        }
        this.keys[pos] = addressIndex;
        this.values[addressIndex] = value;
    }

    @Override
    public int getPositionCount() {
        return this.addresses.size();
    }

    @Override
    public long getInMemorySizeInBytes() {
        return (long)INSTANCE_SIZE + this.size;
    }

    @Override
    public int getAddressIndex(int position, Page hashChannelsPage, long rawHash) {
        return this.getAddressIndex(position, hashChannelsPage);
    }

    @Override
    public int getAddressIndex(int position, Page hashChannelsPage) {
        long value = hashChannelsPage.getBlock(0).getLong(position, 0);
        int pos = PagesHash.getHashPosition(value, this.mask);
        while (this.keys[pos] != -1) {
            if (value == this.values[this.keys[pos]]) {
                return this.keys[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return -1;
    }

    @Override
    public int[] getAddressIndex(int[] positions, Page hashChannelsPage, long[] rawHashes) {
        return this.getAddressIndex(positions, hashChannelsPage);
    }

    @Override
    public int[] getAddressIndex(int[] positions, Page hashChannelsPage) {
        Preconditions.checkArgument((hashChannelsPage.getChannelCount() == 1 ? 1 : 0) != 0, (Object)"Multiple channel page passed to BigintPagesHash");
        int positionCount = positions.length;
        long[] incomingValues = new long[positionCount];
        int[] hashPositions = new int[positionCount];
        this.extractAndHashValues(positions, hashChannelsPage, positionCount, incomingValues, hashPositions);
        int[] found = new int[positionCount];
        int foundCount = 0;
        int[] result = new int[positionCount];
        Arrays.fill(result, -1);
        int[] foundKeys = new int[positionCount];
        this.findPositions(positionCount, hashPositions, foundKeys);
        for (int i = 0; i < positionCount; ++i) {
            if (foundKeys[i] == -1) continue;
            found[foundCount++] = i;
        }
        int remainingCount = this.checkFoundPositions(incomingValues, found, foundCount, result, foundKeys);
        int[] remaining = found;
        this.findRemainingPositions(incomingValues, hashPositions, result, remaining, remainingCount);
        return result;
    }

    private void findRemainingPositions(long[] incomingValues, int[] hashPositions, int[] result, int[] remaining, int remainingCount) {
        block0: for (int i = 0; i < remainingCount; ++i) {
            int index = remaining[i];
            int position = hashPositions[index] + 1 & this.mask;
            while (this.keys[position] != -1) {
                if (this.values[this.keys[position]] == incomingValues[index]) {
                    result[index] = this.keys[position];
                    continue block0;
                }
                position = position + 1 & this.mask;
            }
        }
    }

    private int checkFoundPositions(long[] incomingValues, int[] found, int foundCount, int[] result, int[] foundKeys) {
        int[] remaining = found;
        int remainingCount = 0;
        for (int i = 0; i < foundCount; ++i) {
            int index = found[i];
            if (this.values[foundKeys[index]] == incomingValues[index]) {
                result[index] = foundKeys[index];
                continue;
            }
            remaining[remainingCount++] = index;
        }
        return remainingCount;
    }

    private void findPositions(int positionCount, int[] hashPositions, int[] foundKeys) {
        for (int i = 0; i < positionCount; ++i) {
            foundKeys[i] = this.keys[hashPositions[i]];
        }
    }

    private void extractAndHashValues(int[] positions, Page hashChannelsPage, int positionCount, long[] incomingValues, int[] hashPositions) {
        for (int i = 0; i < positionCount; ++i) {
            incomingValues[i] = hashChannelsPage.getBlock(0).getLong(positions[i], 0);
            hashPositions[i] = PagesHash.getHashPosition(incomingValues[i], this.mask);
        }
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        long pageAddress = this.addresses.getLong(Math.toIntExact(position));
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        this.pagesHashStrategy.appendTo(blockIndex, blockPosition, pageBuilder, outputChannelOffset);
    }

    private boolean isPositionNull(int position) {
        long pageAddress = this.addresses.getLong(position);
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.joinChannelBlocks.get(blockIndex).isNull(blockPosition);
    }

    public static long getEstimatedRetainedSizeInBytes(int positionCount, HashArraySizeSupplier hashArraySizeSupplier, LongArrayList addresses, List<ObjectArrayList<Block>> channels, long blocksSizeInBytes) {
        return SizeOf.sizeOf((long[])addresses.elements()) + (channels.size() > 0 ? SizeOf.sizeOf((Object[])channels.get(0).elements()) * (long)channels.size() : 0L) + blocksSizeInBytes + SizeOf.sizeOfIntArray((int)hashArraySizeSupplier.getHashArraySize(positionCount)) + SizeOf.sizeOfLongArray((int)positionCount);
    }
}

