/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.histogram;

import io.trino.operator.aggregation.histogram.GroupedHistogramState;
import io.trino.operator.aggregation.histogram.HistogramState;
import io.trino.operator.aggregation.histogram.SingleHistogramState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import java.util.Objects;

public class HistogramStateFactory
implements AccumulatorStateFactory<HistogramState> {
    public static final int EXPECTED_SIZE_FOR_HASHING = 10;
    private final Type type;
    private final BlockTypeOperators.BlockPositionEqual equalOperator;
    private final BlockTypeOperators.BlockPositionHashCode hashCodeOperator;

    public HistogramStateFactory(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) BlockTypeOperators.BlockPositionEqual equalOperator, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode hashCodeOperator) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.equalOperator = Objects.requireNonNull(equalOperator, "equalOperator is null");
        this.hashCodeOperator = Objects.requireNonNull(hashCodeOperator, "hashCodeOperator is null");
    }

    public HistogramState createSingleState() {
        return new SingleHistogramState(this.type, this.equalOperator, this.hashCodeOperator, 10);
    }

    public HistogramState createGroupedState() {
        return new GroupedHistogramState(this.type, this.equalOperator, this.hashCodeOperator, 10);
    }
}

